/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.identity;

import com.github.benmanes.caffeine.cache.Cache;
import io.camunda.identity.sdk.Identity;
import io.camunda.identity.sdk.users.Users;
import io.camunda.identity.sdk.users.dto.User;
import io.camunda.optimize.dto.optimize.UserDto;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.identity.CCSMUserCache;
import io.camunda.optimize.service.security.CCSMTokenService;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.platform.commons.util.ReflectionUtils;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.LENIENT)
public class CCSMUserCacheTest {
    public static final String ACCESS_TOKEN = "testToken";
    public static final UserDto TEST_USER_1 = new UserDto("123", "Donna Noble", "donna@email.com", Collections.emptyList());
    public static final UserDto TEST_USER_2 = new UserDto("456", "John Smith", "john@email.com", Collections.emptyList());
    @Mock
    Identity identity;
    @Mock
    Users users;
    @Mock
    CCSMTokenService ccsmTokenService;
    @Mock
    Cache<String, UserDto> ccsmUsersCache;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    ConfigurationService configurationService;
    private CCSMUserCache underTest;

    @BeforeEach
    public void setup() {
        Mockito.when((Object)this.configurationService.getCaches().getUsers().getMaxSize()).thenReturn((Object)10000);
        Mockito.when((Object)this.configurationService.getCaches().getUsers().getDefaultTtlMillis()).thenReturn((Object)600000);
        Mockito.when((Object)this.ccsmTokenService.getCurrentUserAuthToken()).thenReturn(Optional.of(ACCESS_TOKEN));
        Mockito.when((Object)this.identity.users()).thenReturn((Object)this.users);
        Mockito.when((Object)this.users.withAccessToken(ACCESS_TOKEN)).thenReturn((Object)this.users);
        Mockito.when((Object)this.users.isAvailable()).thenReturn((Object)true);
        this.underTest = new CCSMUserCache(this.configurationService, this.ccsmTokenService, this.identity);
        Field ccsmUsersCacheField = (Field)ReflectionUtils.findFields(CCSMUserCache.class, f -> "ccsmUsersCache".equals(f.getName()), (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.TOP_DOWN).get(0);
        ccsmUsersCacheField.setAccessible(true);
        try {
            ccsmUsersCacheField.set(this.underTest, this.ccsmUsersCache);
        }
        catch (IllegalAccessException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
    }

    @Test
    public void searchesUserCacheWithSearchStringOneMatch() {
        Mockito.when((Object)this.ccsmUsersCache.asMap()).thenReturn(new ConcurrentHashMap<String, UserDto>(Map.of(TEST_USER_1.getId(), TEST_USER_1, TEST_USER_2.getId(), TEST_USER_2)));
        List searchResult = this.underTest.searchForIdentityUsingSearchTerm(TEST_USER_1.getFirstName(), 10);
        ((ListAssert)Assertions.assertThat((List)searchResult).usingRecursiveFieldByFieldElementComparator()).containsExactly((Object[])new UserDto[]{TEST_USER_1});
        ((Identity)Mockito.verify((Object)this.identity, (VerificationMode)Mockito.never())).users();
    }

    @Test
    public void searchesUserCacheWithSearchStringMultipleMatches() {
        Mockito.when((Object)this.ccsmUsersCache.asMap()).thenReturn(new ConcurrentHashMap<String, UserDto>(Map.of(TEST_USER_1.getId(), TEST_USER_1, TEST_USER_2.getId(), TEST_USER_2)));
        List searchResult = this.underTest.searchForIdentityUsingSearchTerm("email", 10);
        ((ListAssert)Assertions.assertThat((List)searchResult).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new UserDto[]{TEST_USER_1, TEST_USER_2});
        ((Identity)Mockito.verify((Object)this.identity, (VerificationMode)Mockito.never())).users();
    }

    @Test
    public void returnsAllUsersInCacheOnSearchWithEmptySearchTerm() {
        Mockito.when((Object)this.ccsmUsersCache.asMap()).thenReturn(new ConcurrentHashMap<String, UserDto>(Map.of(TEST_USER_1.getId(), TEST_USER_1, TEST_USER_2.getId(), TEST_USER_2)));
        List searchResult = this.underTest.searchForIdentityUsingSearchTerm("", 10);
        ((ListAssert)Assertions.assertThat((List)searchResult).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new UserDto[]{TEST_USER_1, TEST_USER_2});
    }

    @Test
    public void searchForUsersInCacheUsingEmailOneEmail() {
        Mockito.when((Object)this.ccsmUsersCache.asMap()).thenReturn(new ConcurrentHashMap<String, UserDto>(Map.of(TEST_USER_1.getId(), TEST_USER_1, TEST_USER_2.getId(), TEST_USER_2)));
        List searchResult = this.underTest.searchForUsersUsingEmails(Set.of("donna@email.com"));
        ((ListAssert)Assertions.assertThat((List)searchResult).usingRecursiveFieldByFieldElementComparator()).containsExactly((Object[])new UserDto[]{TEST_USER_1});
        ((Identity)Mockito.verify((Object)this.identity, (VerificationMode)Mockito.never())).users();
    }

    @Test
    public void searchForUsersInCacheUsingEmailMultipleEmailsMultipleMatches() {
        Mockito.when((Object)this.ccsmUsersCache.asMap()).thenReturn(new ConcurrentHashMap<String, UserDto>(Map.of(TEST_USER_1.getId(), TEST_USER_1, TEST_USER_2.getId(), TEST_USER_2)));
        List searchResult = this.underTest.searchForUsersUsingEmails(Stream.of(TEST_USER_1.getEmail(), TEST_USER_2.getEmail()).collect(Collectors.toSet()));
        ((ListAssert)Assertions.assertThat((List)searchResult).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new UserDto[]{TEST_USER_1, TEST_USER_2});
        ((Identity)Mockito.verify((Object)this.identity, (VerificationMode)Mockito.never())).users();
    }

    @Test
    public void searchForUsersInCacheUsingEmailMultipleEmailsOneMatch() {
        Mockito.when((Object)this.ccsmUsersCache.asMap()).thenReturn(new ConcurrentHashMap<String, UserDto>(Map.of(TEST_USER_1.getId(), TEST_USER_1, TEST_USER_2.getId(), TEST_USER_2)));
        Mockito.when((Object)this.users.search((String)ArgumentMatchers.any())).thenReturn(Collections.emptyList());
        List searchResult = this.underTest.searchForUsersUsingEmails(Stream.of(TEST_USER_2.getEmail(), "test@email.com").collect(Collectors.toSet()));
        ((ListAssert)Assertions.assertThat((List)searchResult).usingRecursiveFieldByFieldElementComparator()).containsExactly((Object[])new UserDto[]{TEST_USER_2});
        ((Identity)Mockito.verify((Object)this.identity, (VerificationMode)Mockito.times((int)2))).users();
    }

    @Test
    public void searchForUsersInCacheUsingEmailNoPartialMatching() {
        Mockito.when((Object)this.ccsmUsersCache.asMap()).thenReturn(new ConcurrentHashMap<String, UserDto>(Map.of(TEST_USER_1.getId(), TEST_USER_1, TEST_USER_2.getId(), TEST_USER_2)));
        Mockito.when((Object)this.users.search((String)ArgumentMatchers.any())).thenReturn(List.of(new User(TEST_USER_1.getId(), "donnasUserName", TEST_USER_1.getName(), TEST_USER_1.getEmail())));
        List searchResult = this.underTest.searchForUsersUsingEmails(Stream.of("email.com").collect(Collectors.toSet()));
        Assertions.assertThat((List)searchResult).isEmpty();
    }

    @Test
    public void identityIsSearchedIfNoSearchResultInCache() {
        Mockito.when((Object)this.users.search((String)ArgumentMatchers.any())).thenReturn(List.of(new User(TEST_USER_1.getId(), "donnasUserName", TEST_USER_1.getName(), TEST_USER_1.getEmail())));
        Mockito.when((Object)this.ccsmUsersCache.asMap()).thenReturn(new ConcurrentHashMap<String, UserDto>(Map.of(TEST_USER_2.getId(), TEST_USER_2)));
        List searchResult = this.underTest.searchForIdentityUsingSearchTerm(TEST_USER_1.getFirstName(), 10);
        ((ListAssert)Assertions.assertThat((List)searchResult).usingRecursiveFieldByFieldElementComparator()).containsExactly((Object[])new UserDto[]{TEST_USER_1});
        ((Identity)Mockito.verify((Object)this.identity, (VerificationMode)Mockito.times((int)2))).users();
    }
}

