/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.export;

import io.camunda.optimize.dto.optimize.RoleType;
import io.camunda.optimize.dto.optimize.query.report.AuthorizedReportEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.CommandEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.ReportEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.SingleReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.SingleReportEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.single.SingleReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionRequestDto;
import io.camunda.optimize.exception.OptimizeIntegrationTestException;
import io.camunda.optimize.service.db.report.AuthorizationCheckReportEvaluationHandler;
import io.camunda.optimize.service.db.report.ReportEvaluationInfo;
import io.camunda.optimize.service.db.report.result.RawDataCommandResult;
import io.camunda.optimize.service.export.CsvExportService;
import io.camunda.optimize.service.export.RawDataHelper;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.util.FileReaderUtil;
import java.time.ZoneId;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class CsvExportServiceTest {
    @Mock
    private AuthorizationCheckReportEvaluationHandler reportService;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ConfigurationService configurationService;
    @InjectMocks
    private CsvExportService CSVExportService;

    @BeforeEach
    public void init() {
        Mockito.when((Object)this.configurationService.getCsvConfiguration().getExportCsvLimit()).thenReturn((Object)100);
        Mockito.when((Object)this.configurationService.getCsvConfiguration().getExportCsvDelimiter()).thenReturn((Object)Character.valueOf(','));
    }

    @Test
    public void rawProcessReportCsvExport() {
        RawDataCommandResult rawDataReportResult = new RawDataCommandResult(RawDataHelper.getRawDataProcessInstanceDtos(), (SingleReportDataDto)new ProcessReportDataDto());
        Mockito.when((Object)this.reportService.evaluateReport((ReportEvaluationInfo)ArgumentMatchers.any())).thenReturn((Object)new AuthorizedReportEvaluationResult((ReportEvaluationResult)new SingleReportEvaluationResult((SingleReportDefinitionDto)new SingleProcessReportDefinitionRequestDto(), (CommandEvaluationResult)rawDataReportResult), RoleType.VIEWER));
        byte[] csvContent = (byte[])this.CSVExportService.getCsvBytesForEvaluatedReportResult("", "", ZoneId.of("+1")).orElseThrow(() -> new OptimizeIntegrationTestException("Got no csv response"));
        String actualContent = new String(csvContent);
        String expectedContent = FileReaderUtil.readFileWithWindowsLineSeparator("/csv/process/single/raw_process_data.csv");
        Assertions.assertThat((String)actualContent.replaceAll("\\s+", "")).isEqualTo(expectedContent.replaceAll("\\s+", ""));
    }

    @Test
    public void rawDecisionReportCsvExport() {
        RawDataCommandResult rawDataReportResult = new RawDataCommandResult(RawDataHelper.getRawDataDecisionInstanceDtos(), (SingleReportDataDto)new ProcessReportDataDto());
        Mockito.when((Object)this.reportService.evaluateReport((ReportEvaluationInfo)ArgumentMatchers.any())).thenReturn((Object)new AuthorizedReportEvaluationResult((ReportEvaluationResult)new SingleReportEvaluationResult((SingleReportDefinitionDto)new SingleProcessReportDefinitionRequestDto(), (CommandEvaluationResult)rawDataReportResult), RoleType.VIEWER));
        byte[] csvContent = (byte[])this.CSVExportService.getCsvBytesForEvaluatedReportResult("", "", ZoneId.of("+1")).orElseThrow(() -> new OptimizeIntegrationTestException("Got no csv response"));
        String actualContent = new String(csvContent);
        String expectedContent = FileReaderUtil.readFileWithWindowsLineSeparator("/csv/decision/raw_decision_data.csv");
        Assertions.assertThat((String)actualContent.replaceAll("\\s+", "")).isEqualTo(expectedContent.replaceAll("\\s+", ""));
    }
}

