/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.util;

import io.camunda.optimize.service.db.util.AggregationNameUtil;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

public class AggregationNameUtilTest {
    @ParameterizedTest
    @ValueSource(strings={"var[]>Name", "[varName", "varName]", ">>>varName"})
    public void shouldDetermineExistenceOfIllegalCharacter(String input) {
        boolean containsIllegalChar = AggregationNameUtil.containsIllegalChar((String)input);
        Assertions.assertThat((boolean)containsIllegalChar).isTrue();
    }

    @ParameterizedTest
    @ValueSource(strings={"varName", "_varName_", "!@$%^*&O*", "\\\\!@#"})
    public void shouldNotDetermineExistenceOfIllegalCharacterInValidString(String input) {
        boolean containsIllegalChar = AggregationNameUtil.containsIllegalChar((String)input);
        Assertions.assertThat((boolean)containsIllegalChar).isFalse();
    }

    @ParameterizedTest
    @MethodSource(value={"namesAndExpectedOutput"})
    public void shouldSanitiseAggregationNamesToStripIllegalCharacters(String input, String expectedOutput) {
        String sanitisedAggregationName = AggregationNameUtil.sanitiseAggName((String)input);
        Assertions.assertThat((String)sanitisedAggregationName).isEqualTo(expectedOutput);
    }

    private static Stream<Arguments> namesAndExpectedOutput() {
        return Stream.of(Arguments.of((Object[])new Object[]{"varName", "varName"}), Arguments.of((Object[])new Object[]{"varName>[]", "varName___"}), Arguments.of((Object[])new Object[]{"_var[[[Name_", "_var___Name_"}), Arguments.of((Object[])new Object[]{"[varName]", "_varName_"}), Arguments.of((Object[])new Object[]{">[]>[]>[]", "_________"}));
    }
}

