/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.command.process.mapping;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.ProcessInstanceDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.result.raw.RawDataProcessInstanceDto;
import io.camunda.optimize.dto.optimize.query.variable.SimpleProcessVariableDto;
import io.camunda.optimize.service.db.report.interpreter.util.RawProcessDataResultDtoMapper;
import io.camunda.optimize.service.util.IdGenerator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class RawProcessDataResultDtoMapperTest {
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Test
    public void testMapFromSearchResponseHitCountNotEqualTotalCount() {
        int rawDataLimit = 2;
        RawProcessDataResultDtoMapper mapper = new RawProcessDataResultDtoMapper();
        List<ProcessInstanceDto> processInstanceDtos = this.generateInstanceList(2);
        List result = mapper.mapFrom(processInstanceDtos, this.objectMapper, Collections.emptySet(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
        Assertions.assertThat((List)result).hasSize(2);
    }

    @Test
    public void testMapFromSearchResponseAdditionalVariablesAddedToResults() {
        RawProcessDataResultDtoMapper mapper = new RawProcessDataResultDtoMapper();
        List processInstanceDtos = this.generateInstanceList(5).stream().peek(instance -> {
            SimpleProcessVariableDto variableForInstances = new SimpleProcessVariableDto(IdGenerator.getNextId(), "var1", "String", Collections.singletonList("val1"), 1L);
            instance.setVariables(Collections.singletonList(variableForInstances));
        }).collect(Collectors.toList());
        HashSet<String> varsFromUndisplayedInstances = new HashSet<String>();
        varsFromUndisplayedInstances.add("var2");
        List result = mapper.mapFrom(processInstanceDtos, this.objectMapper, varsFromUndisplayedInstances, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
        ((AbstractListAssert)Assertions.assertThat((List)result).extracting(RawDataProcessInstanceDto::getVariables).isNotEmpty()).allSatisfy(variables -> Assertions.assertThat(variables.keySet()).containsAll(Arrays.asList("var1", "var2")));
    }

    @Test
    public void nullVariableValuesReturnedAsEmptyString() {
        RawProcessDataResultDtoMapper mapper = new RawProcessDataResultDtoMapper();
        List processInstanceDtos = this.generateInstanceList(5).stream().peek(instance -> {
            SimpleProcessVariableDto variableForInstances = new SimpleProcessVariableDto(IdGenerator.getNextId(), "var1", "String", null, 1L);
            instance.setVariables(Collections.singletonList(variableForInstances));
        }).collect(Collectors.toList());
        List result = mapper.mapFrom(processInstanceDtos, this.objectMapper, new HashSet(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
        ((AbstractListAssert)Assertions.assertThat((List)result).extracting(RawDataProcessInstanceDto::getVariables).isNotEmpty()).allSatisfy(variables -> Assertions.assertThat((Map)variables).containsEntry((Object)"var1", (Object)""));
    }

    private List<ProcessInstanceDto> generateInstanceList(Integer rawDataLimit) {
        return IntStream.range(0, rawDataLimit).mapToObj(i -> ProcessInstanceDto.builder().build()).collect(Collectors.toList());
    }
}

