/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.cleanup;

import com.google.common.collect.ImmutableList;
import io.camunda.optimize.dto.optimize.ProcessDefinitionOptimizeDto;
import io.camunda.optimize.dto.optimize.query.PageResultDto;
import io.camunda.optimize.service.cleanup.CleanupService;
import io.camunda.optimize.service.cleanup.EngineDataProcessCleanupService;
import io.camunda.optimize.service.db.reader.ProcessDefinitionReader;
import io.camunda.optimize.service.db.reader.ProcessInstanceReader;
import io.camunda.optimize.service.db.writer.ProcessInstanceWriter;
import io.camunda.optimize.service.db.writer.variable.ProcessVariableUpdateWriter;
import io.camunda.optimize.service.db.writer.variable.VariableUpdateInstanceWriter;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.ConfigurationServiceBuilder;
import io.camunda.optimize.service.util.configuration.cleanup.CleanupConfiguration;
import io.camunda.optimize.service.util.configuration.cleanup.CleanupMode;
import io.camunda.optimize.service.util.configuration.cleanup.ProcessDefinitionCleanupConfiguration;
import io.github.netmikey.logunit.api.LogCapturer;
import java.time.OffsetDateTime;
import java.time.Period;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.ListUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class OptimizeProcessCleanupServiceTest {
    private static final List<String> INSTANCE_IDS = ImmutableList.of((Object)"1", (Object)"2");
    private static final PageResultDto<String> FIRST_PAGE = new PageResultDto("1", 1, INSTANCE_IDS.subList(0, 1));
    private static final PageResultDto<String> SECOND_PAGE = new PageResultDto("1", 1, INSTANCE_IDS.subList(1, 2));
    @RegisterExtension
    LogCapturer logCapturer = LogCapturer.create().captureForType(CleanupService.class);
    @Mock
    private ProcessDefinitionReader processDefinitionReader;
    @Mock
    private ProcessInstanceReader processInstanceReader;
    @Mock
    private ProcessInstanceWriter processInstanceWriter;
    @Mock
    private ProcessVariableUpdateWriter processVariableUpdateWriter;
    @Mock
    private VariableUpdateInstanceWriter variableUpdateInstanceWriter;
    private ConfigurationService configurationService;

    @BeforeEach
    public void init() {
        this.configurationService = ConfigurationServiceBuilder.createDefaultConfiguration();
    }

    @Test
    public void testCleanupRunForMultipleProcessDefinitionsDefaultConfig() {
        List<String> processDefinitionKeys = this.generateRandomDefinitionsKeys(3);
        this.mockProcessDefinitions(processDefinitionKeys);
        this.mockGetProcessInstanceIdsForProcessInstanceDelete(processDefinitionKeys);
        this.mockNextPageOfEntities();
        CleanupService underTest = this.createOptimizeCleanupServiceToTest();
        this.doCleanup(underTest);
        this.assertDeleteProcessInstancesExecutedFor(processDefinitionKeys, this.getCleanupConfiguration().getTtl());
    }

    @Test
    public void testCleanupRunForMultipleProcessDefinitionsDifferentDefaultMode() {
        CleanupMode customMode = CleanupMode.VARIABLES;
        this.getCleanupConfiguration().getProcessDataCleanupConfiguration().setCleanupMode(customMode);
        List<String> processDefinitionKeys = this.generateRandomDefinitionsKeys(3);
        this.mockProcessDefinitions(processDefinitionKeys);
        this.mockGetProcessInstanceIdsForVariableDelete(processDefinitionKeys);
        this.mockNextPageOfEntitiesThatHaveVariables();
        CleanupService underTest = this.createOptimizeCleanupServiceToTest();
        this.doCleanup(underTest);
        this.assertDeleteAllInstanceVariablesExecutedFor(processDefinitionKeys, this.getCleanupConfiguration().getTtl());
    }

    @Test
    public void testCleanupRunForMultipleProcessDefinitionsDifferentDefaultTtl() {
        Period customTtl = Period.parse("P2M");
        this.getCleanupConfiguration().setTtl(customTtl);
        List<String> processDefinitionKeys = this.generateRandomDefinitionsKeys(3);
        this.mockProcessDefinitions(processDefinitionKeys);
        this.mockGetProcessInstanceIdsForProcessInstanceDelete(processDefinitionKeys);
        this.mockNextPageOfEntities();
        CleanupService underTest = this.createOptimizeCleanupServiceToTest();
        this.doCleanup(underTest);
        this.assertDeleteProcessInstancesExecutedFor(processDefinitionKeys, customTtl);
    }

    @Test
    public void testCleanupRunForMultipleProcessDefinitionsSpecificModeOverridesDefault() {
        CleanupMode customMode = CleanupMode.VARIABLES;
        List<String> processDefinitionKeysWithSpecificMode = this.generateRandomDefinitionsKeys(3);
        Map processDefinitionSpecificConfiguration = this.getCleanupConfiguration().getProcessDataCleanupConfiguration().getProcessDefinitionSpecificConfiguration();
        processDefinitionKeysWithSpecificMode.forEach(processDefinitionKey -> processDefinitionSpecificConfiguration.put(processDefinitionKey, new ProcessDefinitionCleanupConfiguration(customMode)));
        List<String> processDefinitionKeysWithDefaultMode = this.generateRandomDefinitionsKeys(3);
        List allProcessDefinitionKeys = ListUtils.union(processDefinitionKeysWithSpecificMode, processDefinitionKeysWithDefaultMode);
        this.mockProcessDefinitions(allProcessDefinitionKeys);
        this.mockGetProcessInstanceIdsForProcessInstanceDelete(processDefinitionKeysWithDefaultMode);
        this.mockGetProcessInstanceIdsForVariableDelete(processDefinitionKeysWithSpecificMode);
        this.mockNextPageOfEntities();
        this.mockNextPageOfEntitiesThatHaveVariables();
        CleanupService underTest = this.createOptimizeCleanupServiceToTest();
        this.doCleanup(underTest);
        this.verifyDeleteProcessInstanceExecutionReturnCapturedArguments(processDefinitionKeysWithDefaultMode);
        this.verifyDeleteAllInstanceVariablesReturnCapturedArguments(processDefinitionKeysWithSpecificMode);
    }

    @Test
    public void testCleanupRunForMultipleProcessDefinitionsSpecificTtlsOverrideDefault() {
        Period customTtl = Period.parse("P2M");
        List<String> processDefinitionKeysWithSpecificTtl = this.generateRandomDefinitionsKeys(3);
        Map processDefinitionSpecificConfiguration = this.getCleanupConfiguration().getProcessDataCleanupConfiguration().getProcessDefinitionSpecificConfiguration();
        processDefinitionKeysWithSpecificTtl.forEach(processDefinitionKey -> processDefinitionSpecificConfiguration.put(processDefinitionKey, new ProcessDefinitionCleanupConfiguration(customTtl)));
        List<String> processDefinitionKeysWithDefaultTtl = this.generateRandomDefinitionsKeys(3);
        List allProcessDefinitionKeys = ListUtils.union(processDefinitionKeysWithSpecificTtl, processDefinitionKeysWithDefaultTtl);
        this.mockProcessDefinitions(allProcessDefinitionKeys);
        this.mockGetProcessInstanceIdsForProcessInstanceDelete(allProcessDefinitionKeys);
        this.mockNextPageOfEntities();
        CleanupService underTest = this.createOptimizeCleanupServiceToTest();
        this.doCleanup(underTest);
        Map<String, OffsetDateTime> capturedArguments = this.verifyDeleteProcessInstanceExecutionReturnCapturedArguments(allProcessDefinitionKeys);
        this.assertInstancesWereRetrievedByKeyAndExpectedTtl(capturedArguments, processDefinitionKeysWithSpecificTtl, customTtl);
        this.assertInstancesWereRetrievedByKeyAndExpectedTtl(capturedArguments, processDefinitionKeysWithDefaultTtl, this.getCleanupConfiguration().getTtl());
    }

    @Test
    public void testCleanupRunOnceForEveryProcessDefinitionKey() {
        List<String> processDefinitionKeys = this.generateRandomDefinitionsKeys(3);
        this.mockProcessDefinitions(ListUtils.union(processDefinitionKeys, processDefinitionKeys));
        this.mockGetProcessInstanceIdsForProcessInstanceDelete(processDefinitionKeys);
        this.mockNextPageOfEntities();
        CleanupService underTest = this.createOptimizeCleanupServiceToTest();
        this.doCleanup(underTest);
        this.assertDeleteProcessInstancesExecutedFor(processDefinitionKeys, this.getCleanupConfiguration().getTtl());
    }

    @Test
    public void testWarnOnCleanupOnSpecificKeyConfigWithNoMatchingProcessDefinition() {
        String misconfiguredKey = "myMistypedKey";
        this.getCleanupConfiguration().getProcessDataCleanupConfiguration().getProcessDefinitionSpecificConfiguration().put("myMistypedKey", new ProcessDefinitionCleanupConfiguration(CleanupMode.VARIABLES));
        List<String> processDefinitionKeys = this.generateRandomDefinitionsKeys(3);
        this.mockProcessDefinitions(processDefinitionKeys);
        this.mockGetProcessInstanceIdsForProcessInstanceDelete(processDefinitionKeys);
        this.mockNextPageOfEntities();
        CleanupService underTest = this.createOptimizeCleanupServiceToTest();
        this.doCleanup(underTest);
        this.assertDeleteProcessInstancesExecutedFor(processDefinitionKeys, this.getCleanupConfiguration().getTtl());
        this.logCapturer.assertContains(String.format("History Cleanup Configuration contains definition keys for which there is no definition imported yet. The keys without a match in the database are: [%s]", "myMistypedKey"));
    }

    private void mockGetProcessInstanceIdsForProcessInstanceDelete(List<String> expectedKeys) {
        expectedKeys.forEach(key -> Mockito.when((Object)this.processInstanceReader.getFirstPageOfProcessInstanceIdsThatEndedBefore((String)ArgumentMatchers.eq((Object)key), (OffsetDateTime)ArgumentMatchers.any(OffsetDateTime.class), Integer.valueOf(ArgumentMatchers.anyInt()))).thenReturn(FIRST_PAGE));
    }

    private void mockNextPageOfEntities() {
        Mockito.when((Object)this.processInstanceReader.getNextPageOfProcessInstanceIdsThatEndedBefore(ArgumentMatchers.anyString(), (OffsetDateTime)ArgumentMatchers.any(OffsetDateTime.class), Integer.valueOf(ArgumentMatchers.anyInt()), (PageResultDto)ArgumentMatchers.eq(FIRST_PAGE))).thenReturn(SECOND_PAGE);
        Mockito.when((Object)this.processInstanceReader.getNextPageOfProcessInstanceIdsThatEndedBefore(ArgumentMatchers.anyString(), (OffsetDateTime)ArgumentMatchers.any(OffsetDateTime.class), Integer.valueOf(ArgumentMatchers.anyInt()), (PageResultDto)ArgumentMatchers.eq(SECOND_PAGE))).thenReturn((Object)new PageResultDto(1));
    }

    private void mockNextPageOfEntitiesThatHaveVariables() {
        Mockito.when((Object)this.processInstanceReader.getNextPageOfProcessInstanceIdsThatHaveVariablesAndEndedBefore(ArgumentMatchers.anyString(), (OffsetDateTime)ArgumentMatchers.any(OffsetDateTime.class), Integer.valueOf(ArgumentMatchers.anyInt()), (PageResultDto)ArgumentMatchers.eq(FIRST_PAGE))).thenReturn(SECOND_PAGE);
        Mockito.when((Object)this.processInstanceReader.getNextPageOfProcessInstanceIdsThatHaveVariablesAndEndedBefore(ArgumentMatchers.anyString(), (OffsetDateTime)ArgumentMatchers.any(OffsetDateTime.class), Integer.valueOf(ArgumentMatchers.anyInt()), (PageResultDto)ArgumentMatchers.eq(SECOND_PAGE))).thenReturn((Object)new PageResultDto(1));
    }

    private void mockGetProcessInstanceIdsForVariableDelete(List<String> expectedKeys) {
        expectedKeys.forEach(key -> Mockito.when((Object)this.processInstanceReader.getFirstPageOfProcessInstanceIdsThatHaveVariablesAndEndedBefore((String)ArgumentMatchers.eq((Object)key), (OffsetDateTime)ArgumentMatchers.any(OffsetDateTime.class), Integer.valueOf(ArgumentMatchers.anyInt()))).thenReturn(FIRST_PAGE));
    }

    private void doCleanup(CleanupService underTest) {
        underTest.doCleanup(OffsetDateTime.now());
    }

    private CleanupConfiguration getCleanupConfiguration() {
        return this.configurationService.getCleanupServiceConfiguration();
    }

    private void assertDeleteProcessInstancesExecutedFor(List<String> expectedProcessDefinitionKeys, Period expectedTtl) {
        Map<String, OffsetDateTime> processInstanceKeysWithDateFilter = this.verifyDeleteProcessInstanceExecutionReturnCapturedArguments(expectedProcessDefinitionKeys);
        this.assertInstancesWereRetrievedByKeyAndExpectedTtl(processInstanceKeysWithDateFilter, expectedProcessDefinitionKeys, expectedTtl);
        ((ProcessInstanceWriter)Mockito.verify((Object)this.processInstanceWriter, (VerificationMode)Mockito.times((int)expectedProcessDefinitionKeys.size()))).deleteByIds((String)ArgumentMatchers.any(), (List)ArgumentMatchers.eq((Object)FIRST_PAGE.getEntities()));
        ((ProcessInstanceWriter)Mockito.verify((Object)this.processInstanceWriter, (VerificationMode)Mockito.times((int)expectedProcessDefinitionKeys.size()))).deleteByIds((String)ArgumentMatchers.any(), (List)ArgumentMatchers.eq((Object)SECOND_PAGE.getEntities()));
        ((VariableUpdateInstanceWriter)Mockito.verify((Object)this.variableUpdateInstanceWriter, (VerificationMode)Mockito.times((int)expectedProcessDefinitionKeys.size()))).deleteByProcessInstanceIds((List)ArgumentMatchers.eq((Object)FIRST_PAGE.getEntities()));
        ((VariableUpdateInstanceWriter)Mockito.verify((Object)this.variableUpdateInstanceWriter, (VerificationMode)Mockito.times((int)expectedProcessDefinitionKeys.size()))).deleteByProcessInstanceIds((List)ArgumentMatchers.eq((Object)SECOND_PAGE.getEntities()));
    }

    private void assertInstancesWereRetrievedByKeyAndExpectedTtl(Map<String, OffsetDateTime> capturedInvocationArguments, List<String> expectedDefinitionKeys, Period expectedTtl) {
        Map<String, OffsetDateTime> filteredInvocationArguments = capturedInvocationArguments.entrySet().stream().filter(entry -> expectedDefinitionKeys.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Assertions.assertThat(filteredInvocationArguments).hasSize(expectedDefinitionKeys.size());
        OffsetDateTime dateFilterValue = filteredInvocationArguments.values().toArray(new OffsetDateTime[0])[0];
        Assertions.assertThat((OffsetDateTime)dateFilterValue).isBeforeOrEqualTo(OffsetDateTime.now().minus(expectedTtl));
        filteredInvocationArguments.values().forEach(instant -> Assertions.assertThat((OffsetDateTime)instant).isEqualTo((Object)dateFilterValue));
    }

    private Map<String, OffsetDateTime> verifyDeleteProcessInstanceExecutionReturnCapturedArguments(List<String> expectedProcessDefinitionKeys) {
        ArgumentCaptor definitionKeyCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor endDateFilterCaptor = ArgumentCaptor.forClass(OffsetDateTime.class);
        ((ProcessInstanceReader)Mockito.verify((Object)this.processInstanceReader, (VerificationMode)Mockito.atLeast((int)expectedProcessDefinitionKeys.size()))).getFirstPageOfProcessInstanceIdsThatEndedBefore((String)definitionKeyCaptor.capture(), (OffsetDateTime)endDateFilterCaptor.capture(), Integer.valueOf(ArgumentMatchers.anyInt()));
        int i = 0;
        HashMap<String, OffsetDateTime> definitionKeysWithDateFilter = new HashMap<String, OffsetDateTime>();
        for (String key : definitionKeyCaptor.getAllValues()) {
            definitionKeysWithDateFilter.put(key, (OffsetDateTime)endDateFilterCaptor.getAllValues().get(i));
            ++i;
        }
        return definitionKeysWithDateFilter;
    }

    private void assertDeleteAllInstanceVariablesExecutedFor(List<String> expectedProcessDefinitionKeys, Period expectedTtl) {
        Map<String, OffsetDateTime> processInstanceKeysWithDateFilter = this.verifyDeleteAllInstanceVariablesReturnCapturedArguments(expectedProcessDefinitionKeys);
        this.assertInstancesWereRetrievedByKeyAndExpectedTtl(processInstanceKeysWithDateFilter, expectedProcessDefinitionKeys, expectedTtl);
    }

    private Map<String, OffsetDateTime> verifyDeleteAllInstanceVariablesReturnCapturedArguments(List<String> expectedProcessDefinitionKeys) {
        ArgumentCaptor processInstanceCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor endDateFilterCaptor = ArgumentCaptor.forClass(OffsetDateTime.class);
        ((ProcessInstanceReader)Mockito.verify((Object)this.processInstanceReader, (VerificationMode)Mockito.atLeast((int)expectedProcessDefinitionKeys.size()))).getFirstPageOfProcessInstanceIdsThatHaveVariablesAndEndedBefore((String)processInstanceCaptor.capture(), (OffsetDateTime)endDateFilterCaptor.capture(), Integer.valueOf(ArgumentMatchers.anyInt()));
        int i = 0;
        HashMap<String, OffsetDateTime> filteredProcessInstancesWithDateFilter = new HashMap<String, OffsetDateTime>();
        for (String key : processInstanceCaptor.getAllValues()) {
            filteredProcessInstancesWithDateFilter.put(key, (OffsetDateTime)endDateFilterCaptor.getAllValues().get(i));
            ++i;
        }
        return filteredProcessInstancesWithDateFilter;
    }

    private void mockProcessDefinitions(List<String> processDefinitionIds) {
        List processDefinitionOptimizeDtos = processDefinitionIds.stream().map(this::createProcessDefinitionDto).collect(Collectors.toList());
        Mockito.when((Object)this.processDefinitionReader.getAllProcessDefinitions()).thenReturn(processDefinitionOptimizeDtos);
    }

    private List<String> generateRandomDefinitionsKeys(Integer amount) {
        return IntStream.range(0, amount).mapToObj(i -> UUID.randomUUID().toString()).toList();
    }

    private ProcessDefinitionOptimizeDto createProcessDefinitionDto(String key) {
        ProcessDefinitionOptimizeDto processDefinitionOptimizeDto = ProcessDefinitionOptimizeDto.builder().key(key).build();
        return processDefinitionOptimizeDto;
    }

    private CleanupService createOptimizeCleanupServiceToTest() {
        return new EngineDataProcessCleanupService(this.configurationService, this.processDefinitionReader, this.processInstanceReader, this.processInstanceWriter, this.processVariableUpdateWriter, this.variableUpdateInstanceWriter);
    }
}

