/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.cleanup;

import io.camunda.optimize.dto.optimize.DecisionDefinitionOptimizeDto;
import io.camunda.optimize.service.cleanup.CleanupService;
import io.camunda.optimize.service.cleanup.EngineDataDecisionCleanupService;
import io.camunda.optimize.service.db.reader.DecisionDefinitionReader;
import io.camunda.optimize.service.db.writer.DecisionInstanceWriter;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.ConfigurationServiceBuilder;
import io.camunda.optimize.service.util.configuration.cleanup.CleanupConfiguration;
import io.camunda.optimize.service.util.configuration.cleanup.DecisionDefinitionCleanupConfiguration;
import io.github.netmikey.logunit.api.LogCapturer;
import java.time.OffsetDateTime;
import java.time.Period;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.SetUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class OptimizeDecisionCleanupServiceTest {
    @RegisterExtension
    LogCapturer logCapturer = LogCapturer.create().captureForType(CleanupService.class);
    @Mock
    private DecisionDefinitionReader decisionDefinitionReader;
    @Mock
    private DecisionInstanceWriter decisionInstanceWriter;
    private ConfigurationService configurationService;

    @BeforeEach
    public void init() {
        this.configurationService = ConfigurationServiceBuilder.createDefaultConfiguration();
    }

    @Test
    public void testCleanupRunForMultipleDecisionDefinitionsDefaultConfig() {
        Set<String> decisionDefinitionKeys = this.generateRandomDefinitionsKeys(3);
        this.mockDecisionDefinitions(decisionDefinitionKeys);
        EngineDataDecisionCleanupService underTest = this.createOptimizeCleanupServiceToTest();
        this.doCleanup((CleanupService)underTest);
        this.assertDeleteDecisionInstancesExecutedFor(decisionDefinitionKeys, this.getCleanupConfiguration().getTtl());
    }

    @Test
    public void testCleanupRunForMultipleDecisionDefinitionsDifferentDefaultTtl() {
        Period customTtl = Period.parse("P2M");
        this.getCleanupConfiguration().setTtl(customTtl);
        Set<String> decisionDefinitionKeys = this.generateRandomDefinitionsKeys(3);
        this.mockDecisionDefinitions(decisionDefinitionKeys);
        EngineDataDecisionCleanupService underTest = this.createOptimizeCleanupServiceToTest();
        this.doCleanup((CleanupService)underTest);
        this.assertDeleteDecisionInstancesExecutedFor(decisionDefinitionKeys, customTtl);
    }

    @Test
    public void testCleanupRunForMultipleDecisionDefinitionsSpecificTtlsOverrideDefault() {
        Period customTtl = Period.parse("P2M");
        Set<String> decisionDefinitionKeysWithSpecificTtl = this.generateRandomDefinitionsKeys(3);
        Map decisionDefinitionSpecificConfiguration = this.getCleanupConfiguration().getDecisionCleanupConfiguration().getDecisionDefinitionSpecificConfiguration();
        decisionDefinitionKeysWithSpecificTtl.forEach(decisionDefinitionKey -> decisionDefinitionSpecificConfiguration.put(decisionDefinitionKey, new DecisionDefinitionCleanupConfiguration(customTtl)));
        Set<String> decisionDefinitionKeysWithDefaultTtl = this.generateRandomDefinitionsKeys(3);
        SetUtils.SetView allDecisionDefinitionKeys = SetUtils.union(decisionDefinitionKeysWithSpecificTtl, decisionDefinitionKeysWithDefaultTtl);
        this.mockDecisionDefinitions((Set<String>)allDecisionDefinitionKeys);
        EngineDataDecisionCleanupService underTest = this.createOptimizeCleanupServiceToTest();
        this.doCleanup((CleanupService)underTest);
        Map<String, OffsetDateTime> capturedArguments = this.verifyDeleteDecisionInstanceExecutionReturnCapturedArguments((Set<String>)allDecisionDefinitionKeys);
        this.assertKeysWereCalledWithExpectedTtl(capturedArguments, decisionDefinitionKeysWithSpecificTtl, customTtl);
        this.assertKeysWereCalledWithExpectedTtl(capturedArguments, decisionDefinitionKeysWithDefaultTtl, this.getCleanupConfiguration().getTtl());
    }

    @Test
    public void testCleanupRunOnceForEveryDecisionDefinitionKey() {
        Set<String> decisionDefinitionKeys = this.generateRandomDefinitionsKeys(3);
        this.mockDecisionDefinitions((Set<String>)SetUtils.union(decisionDefinitionKeys, decisionDefinitionKeys));
        EngineDataDecisionCleanupService underTest = this.createOptimizeCleanupServiceToTest();
        this.doCleanup((CleanupService)underTest);
        this.assertDeleteDecisionInstancesExecutedFor(decisionDefinitionKeys, this.getCleanupConfiguration().getTtl());
    }

    @Test
    public void testWarnOnCleanupOnSpecificKeyConfigWithNoMatchingDecisionDefinition() {
        String misconfiguredKey = "myMistypedKey";
        this.getCleanupConfiguration().getDecisionCleanupConfiguration().getDecisionDefinitionSpecificConfiguration().put("myMistypedKey", new DecisionDefinitionCleanupConfiguration(Period.parse("P2M")));
        Set<String> decisionDefinitionKeys = this.generateRandomDefinitionsKeys(3);
        this.mockDecisionDefinitions(decisionDefinitionKeys);
        EngineDataDecisionCleanupService underTest = this.createOptimizeCleanupServiceToTest();
        this.doCleanup((CleanupService)underTest);
        this.assertDeleteDecisionInstancesExecutedFor(decisionDefinitionKeys, this.getCleanupConfiguration().getTtl());
        this.logCapturer.assertContains(String.format("History Cleanup Configuration contains definition keys for which there is no definition imported yet. The keys without a match in the database are: [%s]", "myMistypedKey"));
    }

    private void doCleanup(CleanupService underTest) {
        underTest.doCleanup(OffsetDateTime.now());
    }

    private CleanupConfiguration getCleanupConfiguration() {
        return this.configurationService.getCleanupServiceConfiguration();
    }

    private void assertKeysWereCalledWithExpectedTtl(Map<String, OffsetDateTime> capturedInvocationArguments, Set<String> expectedDefinitionKeys, Period expectedTtl) {
        Map<String, OffsetDateTime> filteredInvocationArguments = capturedInvocationArguments.entrySet().stream().filter(entry -> expectedDefinitionKeys.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Assertions.assertThat(filteredInvocationArguments).hasSameSizeAs(expectedDefinitionKeys);
        OffsetDateTime dateFilterValue = filteredInvocationArguments.values().toArray(new OffsetDateTime[0])[0];
        Assertions.assertThat((OffsetDateTime)dateFilterValue).isBeforeOrEqualTo(OffsetDateTime.now().minus(expectedTtl));
        filteredInvocationArguments.values().forEach(instant -> Assertions.assertThat((OffsetDateTime)instant).isEqualTo((Object)dateFilterValue));
    }

    private void assertDeleteDecisionInstancesExecutedFor(Set<String> expectedDecisionDefinitionKeys, Period expectedTtl) {
        Map<String, OffsetDateTime> decisionInstanceKeysWithDateFilter = this.verifyDeleteDecisionInstanceExecutionReturnCapturedArguments(expectedDecisionDefinitionKeys);
        this.assertKeysWereCalledWithExpectedTtl(decisionInstanceKeysWithDateFilter, expectedDecisionDefinitionKeys, expectedTtl);
    }

    private Map<String, OffsetDateTime> verifyDeleteDecisionInstanceExecutionReturnCapturedArguments(Set<String> expectedDecisionDefinitionKeys) {
        ArgumentCaptor decisionInstanceCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor evaluationDateFilterCaptor = ArgumentCaptor.forClass(OffsetDateTime.class);
        ((DecisionInstanceWriter)Mockito.verify((Object)this.decisionInstanceWriter, (VerificationMode)Mockito.atLeast((int)expectedDecisionDefinitionKeys.size()))).deleteDecisionInstancesByDefinitionKeyAndEvaluationDateOlderThan((String)decisionInstanceCaptor.capture(), (OffsetDateTime)evaluationDateFilterCaptor.capture());
        int i = 0;
        HashMap<String, OffsetDateTime> filteredDecisionInstancesWithDateFilter = new HashMap<String, OffsetDateTime>();
        for (String key : decisionInstanceCaptor.getAllValues()) {
            filteredDecisionInstancesWithDateFilter.put(key, (OffsetDateTime)evaluationDateFilterCaptor.getAllValues().get(i));
            ++i;
        }
        return filteredDecisionInstancesWithDateFilter;
    }

    private void mockDecisionDefinitions(Set<String> decisionDefinitionKeys) {
        Mockito.when((Object)this.decisionDefinitionReader.getAllDecisionDefinitions()).thenReturn(decisionDefinitionKeys.stream().map(defKeys -> {
            DecisionDefinitionOptimizeDto def = new DecisionDefinitionOptimizeDto();
            def.setKey(defKeys);
            return def;
        }).toList());
    }

    private Set<String> generateRandomDefinitionsKeys(Integer amount) {
        return IntStream.range(0, amount).mapToObj(i -> UUID.randomUUID().toString()).collect(Collectors.toSet());
    }

    private EngineDataDecisionCleanupService createOptimizeCleanupServiceToTest() {
        return new EngineDataDecisionCleanupService(this.configurationService, this.decisionDefinitionReader, this.decisionInstanceWriter);
    }
}

