/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.alert;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.rest.providers.OptimizeExceptionMapper;
import io.camunda.optimize.service.exceptions.OptimizeAlertEmailValidationException;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class OptimizeExceptionMapperTest {
    @Test
    public void exceptionContainsListOfInvalidEmails() {
        Set<String> invalidEmails = Set.of("invalid@email.com", "another@bademail.com");
        OptimizeAlertEmailValidationException emailValidationException = new OptimizeAlertEmailValidationException(invalidEmails);
        OptimizeExceptionMapper underTest = new OptimizeExceptionMapper();
        ResponseEntity response = underTest.handleOptimizeAlertEmailValidationException(emailValidationException);
        Map mappedResponse = (Map)new ObjectMapper().convertValue(response.getBody(), (TypeReference)new TypeReference<Map<String, Object>>(this){});
        Assertions.assertThat((Object)response.getStatusCode()).isEqualTo((Object)HttpStatus.BAD_REQUEST);
        Assertions.assertThat(mappedResponse.get("errorCode")).asString().isEqualTo("invalidAlertEmailAddresses");
        Assertions.assertThat(mappedResponse.get("errorMessage")).asString().isEqualTo("Users with the following email addresses are not available for receiving alerts: " + String.valueOf(invalidEmails));
        Assertions.assertThat(mappedResponse.get("detailedMessage")).asString().isEqualTo("Users with the following email addresses are not available for receiving alerts: " + String.valueOf(invalidEmails));
        Assertions.assertThat(mappedResponse.get("invalidAlertEmails")).asString().isEqualTo(String.join((CharSequence)", ", invalidEmails));
    }
}

