/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class LocalizationFileTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @Test
    public void localizationFilesHaveTheSameKeys() {
        String enLocale = "en";
        String deLocale = "de";
        List<String> enKeys = this.buildQualifiedKeyList(this.getJsonTreeMapFromLocalizationFile("en"), Lists.newArrayList(), null);
        List<String> deKeys = this.buildQualifiedKeyList(this.getJsonTreeMapFromLocalizationFile("de"), Lists.newArrayList(), null);
        Assertions.assertThat(enKeys).containsExactlyInAnyOrderElementsOf(deKeys);
    }

    private List<String> buildQualifiedKeyList(Map<String, Object> jsonMap, List<String> keys, String parentKeyPath) {
        jsonMap.forEach((key, value) -> {
            String qualifiedKeyPath = Optional.ofNullable(parentKeyPath).orElse("") + "/" + key;
            if (value instanceof LinkedHashMap) {
                LinkedHashMap map = (LinkedHashMap)value;
                this.buildQualifiedKeyList(map, keys, qualifiedKeyPath);
            }
            keys.add(qualifiedKeyPath);
        });
        return keys;
    }

    private Map<String, Object> getJsonTreeMapFromLocalizationFile(String locale) {
        try {
            return (Map)OBJECT_MAPPER.readValue(this.getClass().getClassLoader().getResourceAsStream("localization/" + locale + ".json"), Map.class);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
    }
}

