/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.security.cloud;

import io.camunda.optimize.rest.security.cloud.AuthorizationRequestCookieValueMapper;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;

public class AuthorizationRequestCookieValueMapperTest {
    private AuthorizationRequestCookieValueMapper underTest = new AuthorizationRequestCookieValueMapper();

    @Test
    public void equalityAfterDeserialization() {
        OAuth2AuthorizationRequest authorizationRequest = OAuth2AuthorizationRequest.authorizationCode().authorizationUri("https://weblogin.cloud.dev.ultrawombat.com/authorize").redirectUri("http://localhost:8090/sso-callback?uuid=optimize").clientId("whatever").scopes(Set.of("openid", "profile")).state("myState").additionalParameters(Map.of("nonce", "whatever")).authorizationUri("https://weblogin.cloud.dev.ultrawombat.com/authorize?response_type=code").attributes(Map.of("registration_id", "auth0", "nonce", "anotherNonce")).build();
        String serializedString = this.underTest.serialize(authorizationRequest);
        OAuth2AuthorizationRequest deserializedAuthorizationRequest = this.underTest.deserialize(serializedString);
        Assertions.assertThat((Object)deserializedAuthorizationRequest).usingRecursiveComparison().isEqualTo((Object)authorizationRequest);
    }
}

