/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.zeebe.operation.process.modify;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.entities.OperationEntity;
import io.camunda.operate.entities.OperationType;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.util.OperationsManager;
import io.camunda.operate.webapp.rest.dto.operation.ModifyProcessInstanceRequestDto;
import io.camunda.operate.webapp.zeebe.operation.AbstractOperationHandler;
import io.camunda.operate.webapp.zeebe.operation.ModifyProcessZeebeWrapper;
import io.camunda.operate.webapp.zeebe.operation.process.modify.AddTokenHandler;
import io.camunda.operate.webapp.zeebe.operation.process.modify.CancelTokenHandler;
import io.camunda.operate.webapp.zeebe.operation.process.modify.ModifyProcessInstanceHandler;
import io.camunda.operate.webapp.zeebe.operation.process.modify.MoveTokenHandler;
import io.camunda.operate.webapp.zeebe.operation.process.modify.SingleStepModifyProcessInstanceHandler;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.command.ModifyProcessInstanceCommandStep1;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SingleStepModifyProcessInstanceHandler
extends AbstractOperationHandler
implements ModifyProcessInstanceHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleStepModifyProcessInstanceHandler.class);
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private OperationsManager operationsManager;
    @Autowired
    private MoveTokenHandler moveTokenHandler;
    @Autowired
    private AddTokenHandler addTokenHandler;
    @Autowired
    private CancelTokenHandler cancelTokenHandler;
    @Autowired
    private ModifyProcessZeebeWrapper modifyProcessZeebeWrapper;

    public void handleWithException(OperationEntity operation) throws Exception {
        ModifyProcessInstanceRequestDto modifyProcessInstanceRequest = (ModifyProcessInstanceRequestDto)this.objectMapper.readValue(operation.getModifyInstructions(), ModifyProcessInstanceRequestDto.class);
        this.modifyVariables(modifyProcessInstanceRequest, operation);
        ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep2 lastStep = this.processTokenModifications(modifyProcessInstanceRequest, operation);
        this.modifyProcessZeebeWrapper.sendModificationsToZeebe(lastStep);
        this.markAsSent(operation);
        this.operationsManager.completeOperation(operation, false);
    }

    public Set<OperationType> getTypes() {
        return Set.of(OperationType.MODIFY_PROCESS_INSTANCE);
    }

    public void setZeebeClient(ZeebeClient zeebeClient) {
        this.zeebeClient = zeebeClient;
        this.modifyProcessZeebeWrapper.setZeebeClient(zeebeClient);
    }

    private ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep2 processTokenModifications(ModifyProcessInstanceRequestDto modifyProcessInstanceRequest, OperationEntity operation) throws PersistenceException {
        ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 lastStep = null;
        Long processInstanceKey = Long.parseLong(modifyProcessInstanceRequest.getProcessInstanceKey());
        ModifyProcessInstanceCommandStep1 currentStep = this.modifyProcessZeebeWrapper.newModifyProcessInstanceCommand(processInstanceKey);
        List tokenModifications = this.getTokenModifications(modifyProcessInstanceRequest.getModifications());
        Iterator iter = tokenModifications.iterator();
        while (iter.hasNext()) {
            ModifyProcessInstanceRequestDto.Modification modification = (ModifyProcessInstanceRequestDto.Modification)iter.next();
            ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 nextStep = null;
            switch (1.$SwitchMap$io$camunda$operate$webapp$rest$dto$operation$ModifyProcessInstanceRequestDto$Modification$Type[modification.getModification().ordinal()]) {
                case 1: {
                    nextStep = this.addTokenHandler.addToken(currentStep, modification);
                    break;
                }
                case 2: {
                    nextStep = this.cancelTokenHandler.cancelToken(currentStep, processInstanceKey, modification);
                    break;
                }
                case 3: {
                    nextStep = this.moveTokenHandler.moveToken(currentStep, processInstanceKey, modification);
                    break;
                }
                default: {
                    LOGGER.warn("SingleStepModifyProcessInstanceHandler encountered a modification type that should have been filtered out: {}", (Object)modification.getModification());
                }
            }
            if (nextStep != null) {
                lastStep = nextStep;
                if (iter.hasNext()) {
                    currentStep = nextStep.and();
                }
            }
            this.operationsManager.updateFinishedInBatchOperation(operation.getBatchOperationId());
        }
        return lastStep;
    }

    private void updateFinishedInBatchOperation(OperationEntity operation) throws PersistenceException {
        this.operationsManager.updateFinishedInBatchOperation(operation.getBatchOperationId());
    }

    private void modifyVariables(ModifyProcessInstanceRequestDto modifyProcessInstanceRequest, OperationEntity operation) throws PersistenceException {
        Long processInstanceKey = Long.parseLong(modifyProcessInstanceRequest.getProcessInstanceKey());
        List modifications = this.getVariableModifications(modifyProcessInstanceRequest.getModifications());
        for (ModifyProcessInstanceRequestDto.Modification modification : modifications) {
            Long scopeKey = modification.getScopeKey() == null ? processInstanceKey : modification.getScopeKey();
            this.modifyProcessZeebeWrapper.setVariablesInZeebe(scopeKey, modification.getVariables());
            this.updateFinishedInBatchOperation(operation);
        }
    }

    private List<ModifyProcessInstanceRequestDto.Modification> getVariableModifications(List<ModifyProcessInstanceRequestDto.Modification> modifications) {
        return modifications.stream().filter(arg_0 -> this.isVariableModification(arg_0)).collect(Collectors.toList());
    }

    private List<ModifyProcessInstanceRequestDto.Modification> getTokenModifications(List<ModifyProcessInstanceRequestDto.Modification> modifications) {
        return modifications.stream().filter(Predicate.not(arg_0 -> this.isVariableModification(arg_0))).collect(Collectors.toList());
    }

    private boolean isVariableModification(ModifyProcessInstanceRequestDto.Modification modification) {
        return modification.getModification().equals((Object)ModifyProcessInstanceRequestDto.Modification.Type.ADD_VARIABLE) || modification.getModification().equals((Object)ModifyProcessInstanceRequestDto.Modification.Type.EDIT_VARIABLE);
    }
}

