/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.zeebe.operation.process.modify;

import io.camunda.operate.entities.FlowNodeState;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.webapp.reader.FlowNodeInstanceReader;
import io.camunda.operate.webapp.rest.dto.operation.ModifyProcessInstanceRequestDto;
import io.camunda.zeebe.client.api.command.ModifyProcessInstanceCommandStep1;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class CancelTokenHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CancelTokenHandler.class);
    private final FlowNodeInstanceReader flowNodeInstanceReader;

    public CancelTokenHandler(FlowNodeInstanceReader flowNodeInstanceReader) {
        this.flowNodeInstanceReader = flowNodeInstanceReader;
    }

    public ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep2 cancelToken(ModifyProcessInstanceCommandStep1 currentStep, Long processInstanceKey, ModifyProcessInstanceRequestDto.Modification modification) {
        List flowNodeInstanceKeys;
        String flowNodeInstanceKey = modification.getFromFlowNodeInstanceKey();
        if (StringUtils.hasText((String)flowNodeInstanceKey)) {
            LOGGER.debug("Cancel token from flowNodeInstanceKey {} ", (Object)flowNodeInstanceKey);
            flowNodeInstanceKeys = List.of(Long.valueOf(Long.parseLong(flowNodeInstanceKey)));
        } else {
            flowNodeInstanceKeys = this.flowNodeInstanceReader.getFlowNodeInstanceKeysByIdAndStates(processInstanceKey, modification.getFromFlowNodeId(), List.of(FlowNodeState.ACTIVE));
        }
        if (flowNodeInstanceKeys.isEmpty()) {
            throw new OperateRuntimeException(String.format("Abort CANCEL_TOKEN: Can't find not finished flowNodeInstance keys for process instance %s and flowNode id %s", processInstanceKey, modification.getFromFlowNodeId()));
        }
        LOGGER.debug("Cancel token from flowNodeInstanceKeys {} ", (Object)flowNodeInstanceKeys);
        return this.cancelFlowNodeInstances(currentStep, flowNodeInstanceKeys);
    }

    private ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep2 cancelFlowNodeInstances(ModifyProcessInstanceCommandStep1 currentStep, List<Long> flowNodeInstanceKeysToCancel) {
        ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep2 nextStep = null;
        Iterator<Long> iter = flowNodeInstanceKeysToCancel.iterator();
        while (iter.hasNext()) {
            nextStep = currentStep.terminateElement(iter.next().longValue());
            if (!iter.hasNext()) continue;
            nextStep.and();
        }
        return nextStep;
    }
}

