/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.zeebe.operation;

import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.webapp.zeebe.operation.OperationsConfig;
import java.util.concurrent.RejectedExecutionHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class OperationsConfig {
    @Autowired
    private OperateProperties operateProperties;

    @Bean(value={"operationsThreadPoolExecutor"})
    public ThreadPoolTaskExecutor getOperationsThreadPoolExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.operateProperties.getOperationExecutor().getThreadsCount());
        executor.setMaxPoolSize(this.operateProperties.getOperationExecutor().getThreadsCount());
        executor.setQueueCapacity(this.operateProperties.getOperationExecutor().getQueueSize());
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new BlockCallerUntilExecutorHasCapacity(this));
        executor.setThreadNamePrefix("operation_executor_");
        executor.initialize();
        return executor;
    }
}

