/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.zeebe.operation;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.entities.OperationEntity;
import io.camunda.operate.entities.OperationType;
import io.camunda.operate.webapp.rest.dto.operation.MigrationPlanDto;
import io.camunda.operate.webapp.zeebe.operation.AbstractOperationHandler;
import io.camunda.operate.webapp.zeebe.operation.OperationHandler;
import io.camunda.zeebe.client.api.command.MigrationPlan;
import io.camunda.zeebe.client.api.command.MigrationPlanBuilderImpl;
import io.camunda.zeebe.client.api.command.MigrationPlanImpl;
import java.util.ArrayList;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MigrateProcessInstanceHandler
extends AbstractOperationHandler
implements OperationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrateProcessInstanceHandler.class);
    private final ObjectMapper objectMapper;

    public MigrateProcessInstanceHandler(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void handleWithException(OperationEntity operation) throws Exception {
        Long processInstanceKey = operation.getProcessInstanceKey();
        if (processInstanceKey == null) {
            this.failOperation(operation, "No process instance key is provided.");
            return;
        }
        MigrationPlanDto migrationPlanDto = (MigrationPlanDto)this.objectMapper.readValue(operation.getMigrationPlan(), MigrationPlanDto.class);
        LOGGER.info("Operation [{}]: Sending Zeebe migrate command for processInstanceKey [{}]...", (Object)operation.getId(), (Object)processInstanceKey);
        this.migrate(processInstanceKey, migrationPlanDto);
        this.markAsSent(operation);
        LOGGER.info("Operation [{}]: Migrate command sent to Zeebe for processInstanceKey [{}]", (Object)operation.getId(), (Object)processInstanceKey);
    }

    public Set<OperationType> getTypes() {
        return Set.of(OperationType.MIGRATE_PROCESS_INSTANCE);
    }

    public void migrate(Long processInstanceKey, MigrationPlanDto migrationPlanDto) {
        long targetProcessDefinitionKey = Long.parseLong(migrationPlanDto.getTargetProcessDefinitionKey());
        MigrationPlanImpl migrationPlan = new MigrationPlanImpl(targetProcessDefinitionKey, new ArrayList());
        migrationPlanDto.getMappingInstructions().forEach(arg_0 -> MigrateProcessInstanceHandler.lambda$migrate$0((MigrationPlan)migrationPlan, arg_0));
        this.zeebeClient.newMigrateProcessInstanceCommand(processInstanceKey.longValue()).migrationPlan((MigrationPlan)migrationPlan).send().join();
    }

    private static /* synthetic */ void lambda$migrate$0(MigrationPlan migrationPlan, MigrationPlanDto.MappingInstruction mapping) {
        migrationPlan.getMappingInstructions().add(new MigrationPlanBuilderImpl.MappingInstruction(mapping.getSourceElementId(), mapping.getTargetElementId()));
    }
}

