/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.zeebe.operation;

import io.camunda.operate.entities.OperationEntity;
import io.camunda.operate.entities.OperationType;
import io.camunda.operate.entities.dmn.definition.DecisionDefinitionEntity;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.util.OperationsManager;
import io.camunda.operate.webapp.reader.DecisionReader;
import io.camunda.operate.webapp.writer.DecisionWriter;
import io.camunda.operate.webapp.zeebe.operation.AbstractOperationHandler;
import io.camunda.operate.webapp.zeebe.operation.OperationHandler;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeleteDecisionDefinitionHandler
extends AbstractOperationHandler
implements OperationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteDecisionDefinitionHandler.class);
    @Autowired
    private OperationsManager operationsManager;
    @Autowired
    private DecisionReader decisionReader;
    @Autowired
    private DecisionWriter decisionWriter;

    public void handleWithException(OperationEntity operation) throws Exception {
        if (operation.getDecisionDefinitionKey() == null) {
            this.failOperation(operation, "No decision definition key is provided.");
            return;
        }
        DecisionDefinitionEntity decisionDefinition = this.decisionReader.getDecision(operation.getDecisionDefinitionKey());
        long decisionRequirementsKey = decisionDefinition.getDecisionRequirementsKey();
        LOGGER.info(String.format("Operation [%s]: Sending Zeebe delete command for decisionRequirementsKey [%s]...", operation.getId(), decisionRequirementsKey));
        this.zeebeClient.newDeleteResourceCommand(decisionRequirementsKey).send().join();
        this.markAsSent(operation);
        LOGGER.info(String.format("Operation [%s]: Delete command sent to Zeebe for decisionRequirementsKey [%s]", operation.getId(), decisionRequirementsKey));
        long deleted = this.decisionWriter.deleteDecisionInstancesFor(decisionRequirementsKey);
        this.updateInstancesInBatchOperation(operation, deleted);
        LOGGER.info(String.format("Operation [%s]: Deleted %s decision instances", operation.getId(), deleted));
        deleted = this.decisionWriter.deleteDecisionDefinitionsFor(decisionRequirementsKey);
        LOGGER.info(String.format("Operation [%s]: Deleted %s decision definitions", operation.getId(), deleted));
        deleted = this.decisionWriter.deleteDecisionRequirements(decisionRequirementsKey);
        this.completeOperation(operation);
        LOGGER.info(String.format("Operation [%s]: Deleted %s decision requirements", operation.getId(), deleted));
    }

    public Set<OperationType> getTypes() {
        return Set.of(OperationType.DELETE_DECISION_DEFINITION);
    }

    private void completeOperation(OperationEntity operation) throws PersistenceException {
        this.operationsManager.completeOperation(operation);
    }

    private void updateInstancesInBatchOperation(OperationEntity operation, long increment) throws PersistenceException {
        this.operationsManager.updateInstancesInBatchOperation(operation.getBatchOperationId(), increment);
    }
}

