/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security.tenant;

import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.webapp.security.tenant.OperateTenant;
import io.camunda.operate.webapp.security.tenant.TenantAwareAuthentication;
import io.camunda.operate.webapp.security.tenant.TenantService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class TenantService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TenantService.class);
    @Autowired
    private OperateProperties operateProperties;

    public AuthenticatedTenants getAuthenticatedTenants() {
        if (!this.securityContextPresent()) {
            return AuthenticatedTenants.allTenants();
        }
        if (!this.isMultiTenancyEnabled()) {
            return AuthenticatedTenants.assignedTenants(List.of("<default>"));
        }
        TenantAwareAuthentication authentication = this.getCurrentTenantAwareAuthentication();
        List tenants = this.getTenantsFromAuthentication(authentication);
        if (tenants != null && !tenants.isEmpty()) {
            return AuthenticatedTenants.assignedTenants((List)tenants);
        }
        return AuthenticatedTenants.noTenantsAssigned();
    }

    private TenantAwareAuthentication getCurrentTenantAwareAuthentication() {
        TenantAwareAuthentication currentAuthentication;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof TenantAwareAuthentication) {
            TenantAwareAuthentication tenantAwareAuthentication;
            currentAuthentication = tenantAwareAuthentication = (TenantAwareAuthentication)authentication;
        } else {
            currentAuthentication = null;
            String message = String.format("Multi Tenancy is not supported with current authentication type %s", authentication.getClass());
            LOGGER.error(message, (Throwable)new OperateRuntimeException());
        }
        return currentAuthentication;
    }

    private List<String> getTenantsFromAuthentication(TenantAwareAuthentication authentication) {
        List tenants;
        ArrayList<String> authenticatedTenants = new ArrayList<String>();
        if (authentication != null && (tenants = authentication.getTenants()) != null && !tenants.isEmpty()) {
            tenants.stream().map(OperateTenant::getTenantId).collect(Collectors.toCollection(() -> authenticatedTenants));
        }
        return authenticatedTenants;
    }

    private boolean isMultiTenancyEnabled() {
        return this.operateProperties.getMultiTenancy().isEnabled();
    }

    private boolean securityContextPresent() {
        return SecurityContextHolder.getContext().getAuthentication() != null;
    }
}

