/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security.sso;

import com.auth0.client.auth.AuthAPI;
import com.auth0.exception.Auth0Exception;
import com.auth0.json.auth.TokenHolder;
import com.auth0.jwt.JWT;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.net.TokenRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.identity.sdk.Identity;
import io.camunda.identity.sdk.impl.rest.exception.RestException;
import io.camunda.operate.property.Auth0Properties;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.util.SpringContextHolder;
import io.camunda.operate.webapp.security.Permission;
import io.camunda.operate.webapp.security.identity.IdentityAuthorization;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.InsufficientAuthenticationException;

public class TokenAuthentication
extends AbstractAuthenticationToken {
    public static final String ORGANIZATION_ID = "id";
    public static final String ROLES_KEY = "roles";
    private static Logger logger = LoggerFactory.getLogger(TokenAuthentication.class);
    @JsonIgnore
    private final Integer lock = 0;
    private String claimName;
    private String organization;
    private String domain;
    private String clientId;
    private String clientSecret;
    private String idToken;
    private String refreshToken;
    private String accessToken;
    private String salesPlanType;
    private List<Permission> permissions = new ArrayList();
    @JsonIgnore
    private List<IdentityAuthorization> authorizations;
    private Instant lastResourceBasedPermissionsUpdated = Instant.now();

    public TokenAuthentication() {
        super(null);
    }

    public TokenAuthentication(Auth0Properties auth0Properties, String organizationId) {
        this();
        this.claimName = auth0Properties.getClaimName();
        this.organization = organizationId;
        this.domain = auth0Properties.getDomain();
        this.clientId = auth0Properties.getClientId();
        this.clientSecret = auth0Properties.getClientSecret();
    }

    private boolean isIdEqualsOrganization(Map<String, String> orgs) {
        return orgs.containsKey(ORGANIZATION_ID) && orgs.get(ORGANIZATION_ID).equals(this.organization);
    }

    public boolean isAuthenticated() {
        if (this.hasExpired()) {
            logger.info("Tokens are expired");
            if (this.refreshToken == null) {
                this.setAuthenticated(false);
                logger.info("No refresh token available. Authentication is invalid.");
            } else {
                logger.info("Get a new tokens by using refresh token");
                this.getNewTokenByRefreshToken();
            }
        }
        return super.isAuthenticated();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TokenAuthentication that = (TokenAuthentication)o;
        return this.claimName.equals(that.claimName) && this.organization.equals(that.organization) && this.domain.equals(that.domain) && this.clientId.equals(that.clientId) && this.clientSecret.equals(that.clientSecret) && this.idToken.equals(that.idToken) && Objects.equals(this.refreshToken, that.refreshToken) && Objects.equals(this.salesPlanType, that.salesPlanType);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.claimName, this.organization, this.domain, this.clientId, this.clientSecret, this.idToken, this.refreshToken, this.salesPlanType);
    }

    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public void addPermission(Permission permission) {
        this.permissions.add(permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IdentityAuthorization> getAuthorizations() {
        if (this.getIdentity() != null && (this.authorizations == null || this.needToUpdate())) {
            Integer n = this.lock;
            synchronized (n) {
                this.updateResourcePermissions();
            }
        }
        return this.authorizations;
    }

    public TokenAuthentication setAuthorizations(List<IdentityAuthorization> authorizations) {
        this.authorizations = authorizations;
        return this;
    }

    public boolean needToUpdate() {
        Duration duration = Duration.between(this.lastResourceBasedPermissionsUpdated, Instant.now());
        return !duration.minusSeconds(this.getOperateProperties().getIdentity().getResourcePermissionsUpdatePeriod()).isNegative();
    }

    private void updateResourcePermissions() {
        if (this.getOperateProperties().getIdentity().isResourcePermissionsEnabled() && this.getIdentity() != null) {
            try {
                List identityAuthorizations = IdentityAuthorization.createFrom((List)this.getIdentity().authorizations().forToken(this.accessToken, this.getOperateProperties().getCloud().getOrganizationId()));
                logger.debug("Authorizations updated: " + String.valueOf(identityAuthorizations));
                this.authorizations = identityAuthorizations;
                this.lastResourceBasedPermissionsUpdated = Instant.now();
            }
            catch (RestException ex) {
                logger.warn("Unable to retrieve resource base permissions from Identity. Error: " + ex.getMessage(), (Throwable)ex);
                this.authorizations = new ArrayList();
            }
        } else {
            this.authorizations = new ArrayList();
        }
    }

    public String getNewTokenByRefreshToken() {
        try {
            TokenRequest tokenRequest = this.getAuthAPI().renewAuth(this.refreshToken);
            TokenHolder tokenHolder = (TokenHolder)tokenRequest.execute();
            this.authenticate(tokenHolder.getIdToken(), tokenHolder.getRefreshToken(), tokenHolder.getAccessToken());
            logger.info("New tokens received and validated.");
            return this.accessToken;
        }
        catch (Auth0Exception e) {
            logger.error(e.getMessage(), e.getCause());
            this.setAuthenticated(false);
            return null;
        }
    }

    private AuthAPI getAuthAPI() {
        return new AuthAPI(this.domain, this.clientId, this.clientSecret);
    }

    public boolean hasExpired() {
        Date expires = JWT.decode((String)this.idToken).getExpiresAt();
        return expires == null || expires.before(new Date());
    }

    public Date getExpiresAt() {
        return JWT.decode((String)this.idToken).getExpiresAt();
    }

    public String getCredentials() {
        return JWT.decode((String)this.idToken).getToken();
    }

    public Object getPrincipal() {
        return JWT.decode((String)this.idToken).getSubject();
    }

    public void authenticate(String idToken, String refreshToken, String accessToken) {
        this.idToken = idToken;
        this.accessToken = accessToken;
        if (refreshToken != null) {
            this.refreshToken = refreshToken;
        }
        Claim claim = JWT.decode((String)idToken).getClaim(this.claimName);
        this.tryAuthenticateAsListOfMaps(claim);
        if (!this.isAuthenticated()) {
            throw new InsufficientAuthenticationException("No permission for Operate - check your organization id");
        }
    }

    private void tryAuthenticateAsListOfMaps(Claim claim) {
        try {
            List claims = claim.asList(Map.class);
            if (claims != null) {
                this.setAuthenticated(claims.stream().anyMatch(arg_0 -> this.isIdEqualsOrganization(arg_0)));
            }
        }
        catch (JWTDecodeException e) {
            logger.debug("Read organization claim as list of maps failed.", (Throwable)e);
        }
    }

    public Map<String, Claim> getClaims() {
        return JWT.decode((String)this.idToken).getClaims();
    }

    public List<String> getRoles(String organizationsKey) {
        try {
            Map claims = this.getClaims();
            return this.findRolesForOrganization(claims, organizationsKey, this.organization);
        }
        catch (Exception e) {
            logger.error("Could not get roles. Return empty roles list.", (Throwable)e);
            return List.of();
        }
    }

    private List<String> findRolesForOrganization(Map<String, Claim> claims, String organizationsKey, String organization) {
        try {
            Optional<Map> orgInfo;
            List orgInfos = claims.get(organizationsKey).asList(Map.class);
            if (orgInfos != null && (orgInfo = orgInfos.stream().filter(oi -> oi.get(ORGANIZATION_ID).equals(organization)).findFirst()).isPresent()) {
                return (List)orgInfo.get().get(ROLES_KEY);
            }
        }
        catch (Exception e) {
            logger.error(String.format("Couldn't extract roles for organization '%s' in JWT claims. Return empty roles list.", organization), (Throwable)e);
        }
        return List.of();
    }

    public String getSalesPlanType() {
        return this.salesPlanType;
    }

    public void setSalesPlanType(String salesPlanType) {
        this.salesPlanType = salesPlanType;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    private Identity getIdentity() {
        try {
            return (Identity)SpringContextHolder.getBean(Identity.class);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return null;
        }
    }

    private OperateProperties getOperateProperties() {
        return (OperateProperties)SpringContextHolder.getBean(OperateProperties.class);
    }
}

