/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security.sso;

import com.auth0.AuthenticationController;
import io.camunda.operate.webapp.security.BaseWebConfigurer;
import io.camunda.operate.webapp.security.OperateURIs;
import io.camunda.operate.webapp.security.oauth2.OAuth2WebConfigurer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.stereotype.Component;

@Profile(value={"sso-auth"})
@Configuration
@EnableWebSecurity
@Component(value="webSecurityConfig")
public class SSOWebSecurityConfig
extends BaseWebConfigurer {
    @Autowired
    protected OAuth2WebConfigurer oAuth2WebConfigurer;

    @Bean
    public AuthenticationController authenticationController() {
        return AuthenticationController.newBuilder((String)this.operateProperties.getAuth0().getDomain(), (String)this.operateProperties.getAuth0().getClientId(), (String)this.operateProperties.getAuth0().getClientSecret()).build();
    }

    protected void applySecurityFilterSettings(HttpSecurity http) throws Exception {
        if (this.operateProperties.isCsrfPreventionEnabled()) {
            this.logger.info("CSRF Protection enabled");
            this.configureCSRF(http);
        } else {
            http.csrf(csrf -> csrf.disable());
        }
        http.authorizeRequests(authorize -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)authorize.requestMatchers(OperateURIs.AUTH_WHITELIST)).permitAll().requestMatchers(new String[]{"/api/**", "/v*/**", "/**"})).authenticated()).exceptionHandling(handling -> handling.authenticationEntryPoint((x$0, x$1, x$2) -> this.failureHandler(x$0, x$1, x$2)));
    }

    protected void applyOAuth2Settings(HttpSecurity http) throws Exception {
        this.oAuth2WebConfigurer.configure(http);
    }
}

