/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security.sso;

import com.auth0.jwt.interfaces.Claim;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.webapp.rest.dto.UserDto;
import io.camunda.operate.webapp.security.AbstractUserService;
import io.camunda.operate.webapp.security.Permission;
import io.camunda.operate.webapp.security.sso.C8ConsoleService;
import io.camunda.operate.webapp.security.sso.TokenAuthentication;
import io.camunda.operate.webapp.security.sso.model.ClusterMetadata;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"sso-auth"})
public class SSOUserService
extends AbstractUserService<AbstractAuthenticationToken> {
    @Autowired
    private OperateProperties operateProperties;
    @Autowired
    private C8ConsoleService c8ConsoleService;

    public UserDto createUserDtoFrom(AbstractAuthenticationToken abstractAuthentication) {
        if (abstractAuthentication instanceof TokenAuthentication) {
            return this.getUserDtoFor((TokenAuthentication)abstractAuthentication);
        }
        if (abstractAuthentication instanceof JwtAuthenticationToken) {
            return this.getUserDtoFor((JwtAuthenticationToken)abstractAuthentication);
        }
        return null;
    }

    public String getUserToken(AbstractAuthenticationToken authentication) {
        if (authentication instanceof TokenAuthentication) {
            return ((TokenAuthentication)authentication).getNewTokenByRefreshToken();
        }
        throw new UnsupportedOperationException("Not supported for token class: " + authentication.getClass().getName());
    }

    private UserDto getUserDtoFor(JwtAuthenticationToken authentication) {
        List<Permission> permissions = List.of(Permission.READ, Permission.WRITE);
        return new UserDto().setUserId(authentication.getName()).setDisplayName(authentication.getName()).setCanLogout(false).setPermissions(permissions);
    }

    private UserDto getUserDtoFor(TokenAuthentication authentication) {
        Map claims = authentication.getClaims();
        String name = "No name";
        if (claims.containsKey(this.operateProperties.getAuth0().getNameKey())) {
            name = ((Claim)claims.get(this.operateProperties.getAuth0().getNameKey())).asString();
        }
        ClusterMetadata clusterMetadata = this.c8ConsoleService.getClusterMetadata();
        Map appNames2Urls = Map.of();
        if (clusterMetadata != null) {
            appNames2Urls = clusterMetadata.getUrls();
        }
        return new UserDto().setUserId(authentication.getName()).setDisplayName(name).setCanLogout(false).setPermissions(authentication.getPermissions()).setRoles(authentication.getRoles(this.operateProperties.getAuth0().getOrganizationsKey())).setSalesPlanType(authentication.getSalesPlanType()).setC8Links(appNames2Urls);
    }
}

