/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security.sso;

import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.util.RetryOperation;
import io.camunda.operate.webapp.security.sso.TokenAuthentication;
import io.camunda.operate.webapp.security.sso.model.ClusterMetadata;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class C8ConsoleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(C8ConsoleService.class);
    private static final String CONSOLE_CLUSTER_TEMPLATE = "%s/external/organizations/%s/clusters";
    @Autowired
    private OperateProperties operateProperties;
    @Autowired
    @Qualifier(value="auth0_restTemplate")
    private RestTemplate restTemplate;
    private ClusterMetadata clusterMetadata;

    public ClusterMetadata getClusterMetadata() {
        if (this.clusterMetadata == null) {
            try {
                String accessToken = ((TokenAuthentication)SecurityContextHolder.getContext().getAuthentication()).getAccessToken();
                this.clusterMetadata = this.retrieveClusterMetadata(accessToken);
            }
            catch (Exception e) {
                LOGGER.error("Couldn't retrieve ClusterMetadata, return null.", (Throwable)e);
                this.clusterMetadata = null;
            }
        }
        return this.clusterMetadata;
    }

    private ClusterMetadata retrieveClusterMetadata(String accessToken) throws Exception {
        ClusterMetadata clusterMetadata = (ClusterMetadata)RetryOperation.newBuilder().noOfRetry(5).delayInterval(500, TimeUnit.MILLISECONDS).retryOn(new Class[]{IOException.class}).retryConsumer(() -> this.getClusterMetadataFromConsole(accessToken)).message("C8ConsoleService#retrieveClusterMetadata").build().retry();
        return this.addModelerAndConsoleLinksIfNotExists(clusterMetadata);
    }

    private ClusterMetadata addModelerAndConsoleLinksIfNotExists(ClusterMetadata clusterMetadata) {
        TreeMap<ClusterMetadata.AppName, String> urls = new TreeMap<ClusterMetadata.AppName, String>(clusterMetadata.getUrls());
        String organizationId = this.operateProperties.getCloud().getOrganizationId();
        String domain = this.operateProperties.getCloud().getPermissionAudience();
        String clusterId = this.operateProperties.getCloud().getClusterId();
        if (!urls.containsKey(ClusterMetadata.AppName.MODELER)) {
            urls.put(ClusterMetadata.AppName.MODELER, String.format("https://%s.%s/org/%s", ClusterMetadata.AppName.MODELER, domain, organizationId));
        }
        if (!urls.containsKey(ClusterMetadata.AppName.CONSOLE)) {
            urls.put(ClusterMetadata.AppName.CONSOLE, String.format("https://%s.%s/org/%s/cluster/%s", ClusterMetadata.AppName.CONSOLE, domain, organizationId, clusterId));
        }
        clusterMetadata.setUrls(urls);
        return clusterMetadata;
    }

    private ClusterMetadata getClusterMetadataFromConsole(String accessToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        headers.setBearerAuth(accessToken);
        String url = String.format(CONSOLE_CLUSTER_TEMPLATE, this.operateProperties.getCloud().getConsoleUrl(), this.operateProperties.getCloud().getOrganizationId());
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), ClusterMetadata[].class, new Object[0]);
        ClusterMetadata[] clusterMetadatas = (ClusterMetadata[])response.getBody();
        if (clusterMetadatas != null) {
            Optional<ClusterMetadata> clusterMetadataMaybe = Arrays.stream(clusterMetadatas).filter(cm -> cm.getUuid().equals(this.operateProperties.getCloud().getClusterId())).findFirst();
            return clusterMetadataMaybe.orElse(null);
        }
        return null;
    }
}

