/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security.oauth2;

import io.camunda.identity.sdk.Identity;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.util.SpringContextHolder;
import io.camunda.operate.webapp.security.tenant.OperateTenant;
import io.camunda.operate.webapp.security.tenant.TenantAwareAuthentication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

public class IdentityTenantAwareJwtAuthenticationToken
extends JwtAuthenticationToken
implements TenantAwareAuthentication {
    private static final long serialVersionUID = 1L;
    private List<OperateTenant> tenants;

    public IdentityTenantAwareJwtAuthenticationToken(Jwt jwt, Collection<? extends GrantedAuthority> authorities, String name) {
        super(jwt, authorities, name);
    }

    public List<OperateTenant> getTenants() {
        if (this.tenants == null && this.isMultiTenancyEnabled()) {
            this.tenants = this.retrieveTenants();
        }
        return this.tenants;
    }

    private List<OperateTenant> retrieveTenants() {
        try {
            String token = ((Jwt)this.getToken()).getTokenValue();
            List identityTenants = this.getIdentity().tenants().forToken(token);
            if (identityTenants != null) {
                return identityTenants.stream().map(t -> new OperateTenant(t.getTenantId(), t.getName())).collect(Collectors.toList());
            }
            return new ArrayList<OperateTenant>();
        }
        catch (Exception e) {
            throw new InsufficientAuthenticationException(e.getMessage(), (Throwable)e);
        }
    }

    private Identity getIdentity() {
        return (Identity)SpringContextHolder.getBean(Identity.class);
    }

    private OperateProperties getOperateProperties() {
        return (OperateProperties)SpringContextHolder.getBean(OperateProperties.class);
    }

    private boolean isMultiTenancyEnabled() {
        return this.getOperateProperties().getMultiTenancy().isEnabled();
    }
}

