/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security.oauth2;

import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.operate.webapp.security.BaseWebConfigurer;
import io.camunda.operate.webapp.security.oauth2.IdentityJwt2AuthenticationTokenConverter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.env.Environment;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"identity-auth"})
public class IdentityOAuth2WebConfigurer {
    public static final String SPRING_SECURITY_OAUTH_2_RESOURCESERVER_JWT_ISSUER_URI = "spring.security.oauth2.resourceserver.jwt.issuer-uri";
    public static final String SPRING_SECURITY_OAUTH_2_RESOURCESERVER_JWT_JWK_SET_URI = "spring.security.oauth2.resourceserver.jwt.jwk-set-uri";
    public static final String JWKS_PATH = "/protocol/openid-connect/certs";
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentityOAuth2WebConfigurer.class);
    @Autowired
    private Environment env;
    @Autowired
    private IdentityConfiguration identityConfiguration;
    @Autowired
    private IdentityJwt2AuthenticationTokenConverter jwtConverter;

    public void configure(HttpSecurity http) throws Exception {
        if (this.isJWTEnabled()) {
            http.oauth2ResourceServer(serverCustomizer -> serverCustomizer.authenticationEntryPoint((arg_0, arg_1, arg_2) -> this.authenticationFailure(arg_0, arg_1, arg_2)).jwt(jwtCustomizer -> jwtCustomizer.jwtAuthenticationConverter((Converter)this.jwtConverter).jwkSetUri(this.getJwkSetUriProperty())));
            LOGGER.info("Enabled OAuth2 JWT access to Operate API");
        }
    }

    private String getJwkSetUriProperty() {
        Object backendUri;
        if (this.env.containsProperty(SPRING_SECURITY_OAUTH_2_RESOURCESERVER_JWT_JWK_SET_URI)) {
            backendUri = this.env.getProperty(SPRING_SECURITY_OAUTH_2_RESOURCESERVER_JWT_JWK_SET_URI);
            LOGGER.info("Using value in SPRING_SECURITY_OAUTH_2_RESOURCESERVER_JWT_JWK_SET_URI for issuer authentication");
        } else {
            backendUri = this.identityConfiguration.getIssuerBackendUrl() + JWKS_PATH;
            LOGGER.warn("SPRING_SECURITY_OAUTH_2_RESOURCESERVER_JWT_JWK_SET_URI is not present, building issuer authentication uri from issuer backend url.");
        }
        LOGGER.info("Using {} for issuer authentication", backendUri);
        return backendUri;
    }

    private void authenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException e) throws IOException {
        BaseWebConfigurer.sendJSONErrorMessage((HttpServletResponse)response, (String)e.getMessage());
    }

    protected boolean isJWTEnabled() {
        return this.env.containsProperty(SPRING_SECURITY_OAUTH_2_RESOURCESERVER_JWT_ISSUER_URI) || this.env.containsProperty(SPRING_SECURITY_OAUTH_2_RESOURCESERVER_JWT_JWK_SET_URI);
    }
}

