/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security.identity;

import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.webapp.security.SecurityContextWrapper;
import io.camunda.operate.webapp.security.identity.IdentityAuthentication;
import io.camunda.operate.webapp.security.identity.IdentityAuthorization;
import io.camunda.operate.webapp.security.identity.IdentityPermission;
import io.camunda.operate.webapp.security.identity.PermissionsService;
import io.camunda.operate.webapp.security.sso.TokenAuthentication;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

/*
 * Exception performing whole class analysis ignored.
 */
public class PermissionsService {
    public static final String RESOURCE_KEY_ALL = "*";
    public static final String RESOURCE_TYPE_PROCESS_DEFINITION = "process-definition";
    public static final String RESOURCE_TYPE_DECISION_DEFINITION = "decision-definition";
    private static final Logger LOGGER = LoggerFactory.getLogger(PermissionsService.class);
    private final OperateProperties operateProperties;
    private final SecurityContextWrapper securityContextWrapperComponent;

    public PermissionsService(OperateProperties operateProperties, SecurityContextWrapper securityContextWrapperComponent) {
        this.operateProperties = operateProperties;
        this.securityContextWrapperComponent = securityContextWrapperComponent;
    }

    @PostConstruct
    public void logCreated() {
        LOGGER.debug("PermissionsService bean created.");
    }

    public Set<String> getProcessDefinitionPermission(String bpmnProcessId) {
        return this.getProcessDefinitionPermission(bpmnProcessId, true);
    }

    public Set<String> getProcessDefinitionPermission(String bpmnProcessId, boolean includeWildcardPermissions) {
        HashSet<String> permissions = new HashSet<String>();
        this.getIdentityAuthorizations().stream().filter(x -> Objects.equals(x.getResourceKey(), bpmnProcessId) && Objects.equals(x.getResourceType(), "process-definition")).findFirst().ifPresent(x -> {
            if (x.getPermissions() != null) {
                permissions.addAll(x.getPermissions());
            }
        });
        if (includeWildcardPermissions) {
            permissions.addAll(this.getProcessDefinitionPermission("*", false));
        }
        return permissions;
    }

    public Set<String> getDecisionDefinitionPermission(String decisionId) {
        return this.getDecisionDefinitionPermission(decisionId, true);
    }

    public Set<String> getDecisionDefinitionPermission(String decisionId, boolean includeWildcardPermissions) {
        HashSet<String> permissions = new HashSet<String>();
        this.getIdentityAuthorizations().stream().filter(x -> Objects.equals(x.getResourceKey(), decisionId) && Objects.equals(x.getResourceType(), "decision-definition")).findFirst().ifPresent(x -> {
            if (x.getPermissions() != null) {
                permissions.addAll(x.getPermissions());
            }
        });
        if (includeWildcardPermissions) {
            permissions.addAll(this.getDecisionDefinitionPermission("*", false));
        }
        return permissions;
    }

    public boolean hasPermissionForProcess(String bpmnProcessId, IdentityPermission permission) {
        if (!this.permissionsEnabled()) {
            return true;
        }
        if (permission == null) {
            throw new IllegalStateException("Identity permission can't be null");
        }
        return this.getProcessDefinitionPermission(bpmnProcessId).stream().anyMatch(x -> x.equalsIgnoreCase(permission.toString()));
    }

    public boolean hasPermissionForDecision(String decisionId, IdentityPermission permission) {
        if (!this.permissionsEnabled()) {
            return true;
        }
        if (permission == null) {
            throw new IllegalStateException("Identity permission can't be null");
        }
        return this.getDecisionDefinitionPermission(decisionId).stream().anyMatch(x -> x.equalsIgnoreCase(permission.toString()));
    }

    private List<IdentityAuthorization> getIdentityAuthorizations() {
        List list = null;
        Authentication authentication = this.securityContextWrapperComponent.getAuthentication();
        if (authentication == null) {
            return new ArrayList<IdentityAuthorization>();
        }
        if (authentication instanceof IdentityAuthentication) {
            list = ((IdentityAuthentication)authentication).getAuthorizations();
            LOGGER.debug("Following authorizations found for IdentityAuthentication: " + String.valueOf(list));
        } else if (authentication instanceof TokenAuthentication) {
            list = ((TokenAuthentication)authentication).getAuthorizations();
            LOGGER.debug("Following authorizations found for TokenAuthentication: " + String.valueOf(list));
        } else {
            LOGGER.error("Unable to read resource based permissions. Unknown token type: " + authentication.getClass().getSimpleName(), (Throwable)new OperateRuntimeException());
        }
        return list == null ? new ArrayList() : list;
    }

    private boolean permissionsEnabled() {
        return this.operateProperties.getIdentity().isResourcePermissionsEnabled() && !this.isJwtToken();
    }

    private boolean isJwtToken() {
        return this.securityContextWrapperComponent.getAuthentication() instanceof JwtAuthenticationToken;
    }

    public ResourcesAllowed getProcessesWithPermission(IdentityPermission permission) {
        if (permission == null) {
            throw new IllegalStateException("Identity permission can't be null");
        }
        if (this.permissionsEnabled()) {
            List processAuthorizations = this.getIdentityAuthorizations().stream().filter(x -> Objects.equals(x.getResourceType(), "process-definition")).collect(Collectors.toList());
            HashSet<String> ids = new HashSet<String>();
            for (IdentityAuthorization authorization : processAuthorizations) {
                if (authorization.getPermissions() == null || !authorization.getPermissions().contains(permission.name())) continue;
                if ("*".equals(authorization.getResourceKey())) {
                    return ResourcesAllowed.all();
                }
                ids.add(authorization.getResourceKey());
            }
            return ResourcesAllowed.withIds(ids);
        }
        return ResourcesAllowed.all();
    }

    public ResourcesAllowed getDecisionsWithPermission(IdentityPermission permission) {
        if (permission == null) {
            throw new IllegalStateException("Identity permission can't be null");
        }
        if (this.permissionsEnabled()) {
            List decisionAuthorizations = this.getIdentityAuthorizations().stream().filter(x -> Objects.equals(x.getResourceType(), "decision-definition")).collect(Collectors.toList());
            HashSet<String> ids = new HashSet<String>();
            for (IdentityAuthorization authorization : decisionAuthorizations) {
                if (authorization.getPermissions() == null || !authorization.getPermissions().contains(permission.name())) continue;
                if ("*".equals(authorization.getResourceKey())) {
                    return ResourcesAllowed.all();
                }
                ids.add(authorization.getResourceKey());
            }
            return ResourcesAllowed.withIds(ids);
        }
        return ResourcesAllowed.all();
    }
}

