/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security.identity;

import io.camunda.operate.webapp.security.BaseWebConfigurer;
import io.camunda.operate.webapp.security.OperateURIs;
import io.camunda.operate.webapp.security.oauth2.IdentityOAuth2WebConfigurer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.stereotype.Component;

@Profile(value={"identity-auth"})
@EnableWebSecurity
@Component(value="webSecurityConfig")
public class IdentityWebSecurityConfig
extends BaseWebConfigurer {
    @Autowired
    protected IdentityOAuth2WebConfigurer oAuth2WebConfigurer;

    protected void applySecurityFilterSettings(HttpSecurity http) throws Exception {
        if (this.operateProperties.isCsrfPreventionEnabled()) {
            this.logger.info("CSRF Protection enabled");
            this.configureCSRF(http);
        } else {
            http.csrf(csrf -> csrf.disable());
        }
        http.authorizeRequests(authorize -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)authorize.requestMatchers(OperateURIs.AUTH_WHITELIST)).permitAll().requestMatchers(new String[]{"/api/**", "/v*/**", "/"})).authenticated()).exceptionHandling(handling -> handling.authenticationEntryPoint((x$0, x$1, x$2) -> this.failureHandler(x$0, x$1, x$2)));
    }

    protected void applyOAuth2Settings(HttpSecurity http) throws Exception {
        this.oAuth2WebConfigurer.configure(http);
    }
}

