/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security.identity;

import io.camunda.identity.sdk.Identity;
import io.camunda.identity.sdk.authentication.Tokens;
import io.camunda.identity.sdk.authentication.dto.AuthCodeDto;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.webapp.security.SecurityContextWrapper;
import io.camunda.operate.webapp.security.identity.IdentityAuthentication;
import io.camunda.operate.webapp.security.identity.IdentityRetryService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"identity-auth"})
public class IdentityService {
    private final OperateProperties operateProperties;
    private final Identity identity;
    private final IdentityRetryService identityRetryService;
    private final SecurityContextWrapper securityContextWrapper;

    @Autowired
    public IdentityService(IdentityRetryService identityRetryService, OperateProperties operateProperties, Identity identity, SecurityContextWrapper securityContextWrapper) {
        this.identityRetryService = identityRetryService;
        this.operateProperties = operateProperties;
        this.identity = identity;
        this.securityContextWrapper = securityContextWrapper;
    }

    public String getRedirectUrl(HttpServletRequest req) {
        return this.identity.authentication().authorizeUriBuilder(this.getRedirectURI(req, "/identity-callback")).build().toString();
    }

    public void logout() {
        IdentityAuthentication authentication = (IdentityAuthentication)this.securityContextWrapper.getAuthentication();
        this.identity.authentication().revokeToken(authentication.getTokens().getRefreshToken());
    }

    public String getRedirectURI(HttpServletRequest req, String redirectTo) {
        String result;
        Object redirectRootUri;
        String fixedRedirectRootUrl = this.operateProperties.getIdentity().getRedirectRootUrl();
        if (StringUtils.isNotBlank((CharSequence)fixedRedirectRootUrl)) {
            redirectRootUri = fixedRedirectRootUrl;
        } else {
            redirectRootUri = req.getScheme() + "://" + req.getServerName();
            if (req.getScheme().equals("http") && req.getServerPort() != 80 || req.getScheme().equals("https") && req.getServerPort() != 443) {
                redirectRootUri = (String)redirectRootUri + ":" + req.getServerPort();
            }
        }
        if (this.contextPathIsUUID(req.getContextPath())) {
            String clusterId = req.getContextPath().replace("/", "");
            result = (String)redirectRootUri + redirectTo + "?uuid=" + clusterId;
        } else {
            result = (String)redirectRootUri + req.getContextPath() + redirectTo;
        }
        return result;
    }

    public IdentityAuthentication getAuthenticationFor(HttpServletRequest req, AuthCodeDto authCodeDto) throws Exception {
        Tokens tokens = (Tokens)this.identityRetryService.requestWithRetry(() -> this.identity.authentication().exchangeAuthCode(authCodeDto, this.getRedirectURI(req, "/identity-callback")), "IdentityService#getAuthentication");
        IdentityAuthentication authentication = new IdentityAuthentication();
        authentication.authenticate(tokens);
        return authentication;
    }

    private boolean contextPathIsUUID(String contextPath) {
        try {
            UUID.fromString(contextPath.replace("/", ""));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

