/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security.identity;

import io.camunda.identity.sdk.authentication.dto.AuthCodeDto;
import io.camunda.operate.webapp.security.identity.IdentityAuthentication;
import io.camunda.operate.webapp.security.identity.IdentityService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Profile(value={"identity-auth"})
public class IdentityController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IdentityService identityService;
    private final SecurityContextRepository securityContextRepository = new HttpSessionSecurityContextRepository();
    private final SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();

    @Autowired
    public IdentityController(IdentityService identityService) {
        this.identityService = identityService;
    }

    @RequestMapping(value={"/api/login"}, method={RequestMethod.GET, RequestMethod.POST})
    public String login(HttpServletRequest req) {
        String authorizeUrl = this.identityService.getRedirectUrl(req);
        this.logger.debug("Redirect Login to {}", (Object)authorizeUrl);
        return "redirect:" + authorizeUrl;
    }

    @GetMapping(value={"/identity-callback"})
    public void loggedInCallback(HttpServletRequest req, HttpServletResponse res, @RequestParam(required=false, name="code") String code, @RequestParam(required=false, name="state") String state, @RequestParam(required=false, name="error") String error) throws IOException {
        AuthCodeDto authCodeDto = new AuthCodeDto(code, state, error);
        this.logger.debug("Called back by identity with {} {}, SessionId: {} and AuthCode {}", new Object[]{req.getRequestURI(), req.getQueryString(), req.getSession().getId(), authCodeDto.getCode()});
        try {
            IdentityAuthentication authentication = this.identityService.getAuthenticationFor(req, authCodeDto);
            SecurityContext context = this.securityContextHolderStrategy.createEmptyContext();
            context.setAuthentication((Authentication)authentication);
            this.securityContextHolderStrategy.setContext(context);
            this.securityContextRepository.saveContext(context, req, res);
            this.redirectToPage(req, res);
        }
        catch (Exception iae) {
            this.clearContextAndRedirectToNoPermission(req, res, (Throwable)iae);
        }
    }

    private void redirectToPage(HttpServletRequest req, HttpServletResponse res) throws IOException {
        Object originalRequestUrl = req.getSession().getAttribute("requestedUrl");
        if (originalRequestUrl != null) {
            res.sendRedirect(req.getContextPath() + String.valueOf(originalRequestUrl));
        } else {
            res.sendRedirect(req.getContextPath() + "/");
        }
    }

    @RequestMapping(value={"/noPermission"})
    @ResponseBody
    public String noPermissions() {
        return "No permission for Operate - Please check your operate configuration or cloud configuration.";
    }

    @RequestMapping(value={"/api/logout"})
    public void logout(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.logger.debug("logout user");
        try {
            this.identityService.logout();
        }
        catch (Exception e) {
            this.logger.error("An error occurred in logout process", (Throwable)e);
        }
        this.cleanup(req);
    }

    protected void clearContextAndRedirectToNoPermission(HttpServletRequest req, HttpServletResponse res, Throwable t) throws IOException {
        this.logger.error("Error in authentication callback: ", t);
        this.cleanup(req);
        res.sendRedirect("/noPermission");
    }

    protected void cleanup(HttpServletRequest req) {
        req.getSession().invalidate();
        SecurityContext context = this.securityContextHolderStrategy.getContext();
        if (context != null) {
            context.setAuthentication(null);
            this.securityContextHolderStrategy.clearContext();
        }
    }
}

