/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security.identity;

import io.camunda.identity.sdk.authorizations.dto.Authorization;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class IdentityAuthorization
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String resourceKey;
    private String resourceType;
    private Set<String> permissions;

    public static IdentityAuthorization createFrom(Authorization authorization) {
        return new IdentityAuthorization().setResourceKey(authorization.getResourceKey()).setResourceType(authorization.getResourceType()).setPermissions(authorization.getPermissions());
    }

    public static List<IdentityAuthorization> createFrom(List<Authorization> authorizations) {
        if (authorizations == null) {
            return new ArrayList<IdentityAuthorization>();
        }
        return authorizations.stream().filter(Objects::nonNull).map(IdentityAuthorization::createFrom).collect(Collectors.toList());
    }

    public String getResourceKey() {
        return this.resourceKey;
    }

    public IdentityAuthorization setResourceKey(String resourceKey) {
        this.resourceKey = resourceKey;
        return this;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public IdentityAuthorization setResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public Set<String> getPermissions() {
        return this.permissions;
    }

    public IdentityAuthorization setPermissions(Set<String> permissions) {
        this.permissions = new HashSet<String>(permissions);
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.resourceKey, this.resourceType, this.permissions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityAuthorization that = (IdentityAuthorization)o;
        return Objects.equals(this.resourceKey, that.resourceKey) && Objects.equals(this.resourceType, that.resourceType) && Objects.equals(this.permissions, that.permissions);
    }

    public String toString() {
        return "IdentityAuthorization{resourceKey='" + this.resourceKey + "', resourceType='" + this.resourceType + "', permissions=" + String.valueOf(this.permissions) + "}";
    }
}

