/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security.auth;

import io.camunda.operate.conditions.DatabaseInfo;
import io.camunda.operate.entities.UserEntity;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.store.UserStore;
import io.camunda.operate.util.CollectionUtil;
import io.camunda.operate.webapp.rest.exception.NotFoundException;
import io.camunda.operate.webapp.security.auth.Role;
import io.camunda.operate.webapp.security.auth.User;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

@Configuration
@Profile(value={"!ldap-auth & !sso-auth & !identity-auth"})
public class OperateUserDetailsService
implements UserDetailsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperateUserDetailsService.class);
    private static final String READ_ONLY_USER = "view";
    private static final String ACT_USERNAME = "act";
    private static final String ACT_PASSWORD = "act";
    @Autowired
    private UserStore userStore;
    @Autowired
    private OperateProperties operateProperties;

    @Bean
    public PasswordEncoder getPasswordEncoder() {
        return new BCryptPasswordEncoder();
    }

    public void initializeUsers() {
        if (this.needsToCreateUser()) {
            String userId = this.operateProperties.getUserId();
            if (!this.userExists(userId)) {
                this.addUserWith(userId, this.operateProperties.getDisplayName(), this.operateProperties.getPassword(), this.operateProperties.getRoles());
            }
            if (!this.userExists(READ_ONLY_USER)) {
                this.addUserWith(READ_ONLY_USER, READ_ONLY_USER, READ_ONLY_USER, List.of(Role.USER.name()));
            }
            if (!this.userExists("act")) {
                this.addUserWith("act", "act", "act", List.of(Role.OPERATOR.name()));
            }
        }
    }

    private boolean needsToCreateUser() {
        if (DatabaseInfo.isOpensearch()) {
            return this.operateProperties.getOpensearch().isCreateSchema();
        }
        return this.operateProperties.getElasticsearch().isCreateSchema();
    }

    private OperateUserDetailsService addUserWith(String userId, String displayName, String password, List<String> roles) {
        LOGGER.info("Create user in {} for userId {}", (Object)DatabaseInfo.getCurrent().getCode(), (Object)userId);
        String passwordEncoded = this.getPasswordEncoder().encode((CharSequence)password);
        UserEntity userEntity = ((UserEntity)new UserEntity().setId(userId)).setUserId(userId).setDisplayName(displayName).setPassword(passwordEncoded).setRoles(roles);
        this.userStore.save(userEntity);
        return this;
    }

    public User loadUserByUsername(String userId) {
        try {
            UserEntity userEntity = this.userStore.getById(userId);
            return new User(userEntity.getUserId(), userEntity.getDisplayName(), userEntity.getPassword(), CollectionUtil.map((Collection)userEntity.getRoles(), Role::fromString));
        }
        catch (NotFoundException e) {
            throw new UsernameNotFoundException(String.format("User with userId '%s' not found.", userId), (Throwable)e);
        }
    }

    private boolean userExists(String userId) {
        try {
            return this.userStore.getById(userId) != null;
        }
        catch (Exception t) {
            return false;
        }
    }
}

