/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security;

import io.camunda.operate.webapp.security.BaseWebConfigurer;
import io.camunda.operate.webapp.security.oauth2.OAuth2WebConfigurer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Component;

@Profile(value={"auth"})
@EnableWebSecurity
@Configuration
@Component(value="webSecurityConfig")
public class WebSecurityConfig
extends BaseWebConfigurer {
    @Autowired
    protected OAuth2WebConfigurer oAuth2WebConfigurer;
    @Autowired
    private UserDetailsService userDetailsService;

    protected void applyAuthenticationSettings(AuthenticationManagerBuilder builder) throws Exception {
        builder.userDetailsService(this.userDetailsService);
    }

    protected void applyOAuth2Settings(HttpSecurity http) throws Exception {
        this.oAuth2WebConfigurer.configure(http);
    }
}

