/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security;

import io.camunda.operate.webapp.security.OperateSession;
import io.camunda.operate.webapp.security.SessionRepository;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.session.config.annotation.web.http.EnableSpringHttpSession;
import org.springframework.stereotype.Component;

@Configuration
@ConditionalOnExpression(value="${camunda.operate.persistent.sessions.enabled:false} or ${camunda.operate.persistentSessionsEnabled:false}")
@Component
@EnableSpringHttpSession
public class SessionService
implements org.springframework.session.SessionRepository<OperateSession> {
    public static final int DELETE_EXPIRED_SESSIONS_DELAY = 1800000;
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionService.class);
    @Autowired
    SessionRepository sessionRepository;
    @Autowired
    @Qualifier(value="sessionThreadPoolScheduler")
    private ThreadPoolTaskScheduler sessionThreadScheduler;

    @PostConstruct
    private void setUp() {
        LOGGER.debug("Persistent sessions in enabled");
        this.startExpiredSessionCheck();
    }

    @PreDestroy
    private void tearDown() {
        LOGGER.debug("Shutdown SessionService");
    }

    private void startExpiredSessionCheck() {
        this.sessionThreadScheduler.scheduleAtFixedRate(() -> this.removedExpiredSessions(), 1800000L);
    }

    private void removedExpiredSessions() {
        LOGGER.debug("Check for expired sessions");
        this.sessionRepository.getExpiredSessionIds().forEach(arg_0 -> this.deleteById(arg_0));
    }

    private boolean shouldDeleteSession(OperateSession session) {
        return session.isExpired() || session.containsAuthentication() && !session.isAuthenticated();
    }

    public OperateSession createSession() {
        String sessionId = UUID.randomUUID().toString().replace("-", "");
        OperateSession session = new OperateSession(sessionId);
        LOGGER.debug("Create session {} with maxInactiveInterval {} ", (Object)session, (Object)session.getMaxInactiveInterval());
        return session;
    }

    public void save(OperateSession session) {
        LOGGER.debug("Save session {}", (Object)session);
        if (this.shouldDeleteSession(session)) {
            this.deleteById(session.getId());
            return;
        }
        if (session.isChanged()) {
            LOGGER.debug("Session {} changed, save in Elasticsearch.", (Object)session);
            this.sessionRepository.save(session);
            session.clearChangeFlag();
        }
    }

    public OperateSession findById(String id) {
        LOGGER.debug("Retrieve session {} from Elasticsearch", (Object)id);
        Optional maybeSession = this.sessionRepository.findById(id);
        if (maybeSession.isEmpty()) {
            this.deleteById(id);
            return null;
        }
        OperateSession session = (OperateSession)maybeSession.get();
        if (this.shouldDeleteSession(session)) {
            this.deleteById(session.getId());
            return null;
        }
        return session;
    }

    public void deleteById(String id) {
        this.executeAsyncElasticsearchRequest(() -> this.sessionRepository.deleteById(id));
    }

    private void executeAsyncElasticsearchRequest(Runnable requestRunnable) {
        this.sessionThreadScheduler.execute(requestRunnable);
    }
}

