/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security;

import io.camunda.operate.exceptions.OperateRuntimeException;
import jakarta.servlet.http.HttpServletRequest;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.regex.Pattern;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class CsrfRequireMatcher
implements RequestMatcher {
    private static final Pattern ALLOWED_METHODS = Pattern.compile("^(GET|HEAD|TRACE|OPTIONS)$");
    private static final Pattern ALLOWED_PATHS = Pattern.compile("/api/login|/api/logout");

    public boolean matches(HttpServletRequest request) {
        String baseRequestUrl;
        if (ALLOWED_METHODS.matcher(request.getMethod()).matches()) {
            return false;
        }
        if (ALLOWED_PATHS.matcher(request.getServletPath()).matches()) {
            return false;
        }
        String referer = request.getHeader("Referer");
        try {
            URL requestUrl = URI.create(request.getRequestURL().toString()).toURL();
            baseRequestUrl = requestUrl.getProtocol() + "://" + requestUrl.getHost() + (String)(requestUrl.getPort() > 0 ? ":" + requestUrl.getPort() : "");
        }
        catch (MalformedURLException e) {
            throw new OperateRuntimeException((Throwable)e);
        }
        if (referer != null && referer.matches(baseRequestUrl + "/swagger-ui.*")) {
            return false;
        }
        String authorizationHeader = request.getHeader("Authorization");
        boolean isAuthorizationHeaderPresent = authorizationHeader != null && authorizationHeader.startsWith("Bearer ");
        return !isAuthorizationHeaderPresent;
    }
}

