/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest.validation;

import io.camunda.operate.webapp.rest.dto.VariableRequestDto;
import io.camunda.operate.webapp.rest.dto.metadata.FlowNodeMetadataRequestDto;
import io.camunda.operate.webapp.rest.dto.operation.CreateBatchOperationRequestDto;
import io.camunda.operate.webapp.rest.dto.operation.CreateOperationRequestDto;
import io.camunda.operate.webapp.rest.exception.InvalidRequestException;
import io.camunda.operate.webapp.rest.validation.CreateBatchOperationRequestValidator;
import io.camunda.operate.webapp.rest.validation.CreateRequestOperationValidator;
import org.springframework.stereotype.Component;

@Component
public class ProcessInstanceRequestValidator {
    private final CreateBatchOperationRequestValidator createBatchOperationRequestValidator;
    private final CreateRequestOperationValidator createRequestOperationValidator;

    public ProcessInstanceRequestValidator(CreateRequestOperationValidator createRequestOperationValidator, CreateBatchOperationRequestValidator createBatchOperationRequestValidator) {
        this.createRequestOperationValidator = createRequestOperationValidator;
        this.createBatchOperationRequestValidator = createBatchOperationRequestValidator;
    }

    public void validateFlowNodeMetadataRequest(FlowNodeMetadataRequestDto request) {
        if (request.getFlowNodeId() == null && request.getFlowNodeType() == null && request.getFlowNodeInstanceId() == null) {
            throw new InvalidRequestException("At least flowNodeId or flowNodeInstanceId must be specifies in the request.");
        }
        if (request.getFlowNodeId() != null && request.getFlowNodeInstanceId() != null) {
            throw new InvalidRequestException("Only one of flowNodeId or flowNodeInstanceId must be specifies in the request.");
        }
    }

    public void validateVariableRequest(VariableRequestDto request) {
        if (request.getScopeId() == null) {
            throw new InvalidRequestException("ScopeId must be specifies in the request.");
        }
    }

    public void validateCreateBatchOperationRequest(CreateBatchOperationRequestDto batchOperationRequest) {
        this.createBatchOperationRequestValidator.validate(batchOperationRequest);
    }

    public void validateCreateOperationRequest(CreateOperationRequestDto operationRequest, String processInstanceId) {
        this.createRequestOperationValidator.validate(operationRequest, processInstanceId);
    }
}

