/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest.validation;

import io.camunda.operate.entities.OperationType;
import io.camunda.operate.webapp.rest.dto.operation.CreateBatchOperationRequestDto;
import io.camunda.operate.webapp.rest.dto.operation.MigrationPlanDto;
import io.camunda.operate.webapp.rest.dto.operation.ModifyProcessInstanceRequestDto;
import io.camunda.operate.webapp.rest.exception.InvalidRequestException;
import io.camunda.operate.webapp.rest.validation.CreateBatchOperationRequestValidator;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class CreateBatchOperationRequestValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateBatchOperationRequestValidator.class);

    public void validate(CreateBatchOperationRequestDto batchOperationRequest) {
        if (batchOperationRequest.getQuery() == null) {
            throw new InvalidRequestException("List view query must be defined.");
        }
        OperationType operationType = batchOperationRequest.getOperationType();
        if (operationType == null) {
            throw new InvalidRequestException("Operation type must be defined.");
        }
        if (operationType != OperationType.MODIFY_PROCESS_INSTANCE && batchOperationRequest.getModifications() != null) {
            throw new InvalidRequestException(String.format("Modifications field not supported for %s operation", operationType));
        }
        switch (1.$SwitchMap$io$camunda$operate$entities$OperationType[operationType.ordinal()]) {
            case 1: 
            case 2: {
                throw new InvalidRequestException("For variable update use \"Create operation for one process instance\" endpoint.");
            }
            case 3: {
                this.validateMigrateProcessInstanceType(batchOperationRequest);
                break;
            }
            case 4: {
                this.validateModifyProcessInstanceType(batchOperationRequest);
                break;
            }
        }
    }

    private void validateModifyProcessInstanceType(CreateBatchOperationRequestDto batchOperationRequest) {
        List modifications = batchOperationRequest.getModifications();
        if (CollectionUtils.isEmpty((Collection)modifications)) {
            throw new InvalidRequestException("Operation requires a single modification entry.");
        }
        if (modifications.size() > 1) {
            LOGGER.warn("Multiple modifications in request, only one will be processed.");
            batchOperationRequest.setModifications(List.of((ModifyProcessInstanceRequestDto.Modification)modifications.get(0)));
        }
    }

    private void validateMigrateProcessInstanceType(CreateBatchOperationRequestDto batchOperationRequest) {
        MigrationPlanDto migrationPlanDto = batchOperationRequest.getMigrationPlan();
        if (migrationPlanDto == null) {
            throw new InvalidRequestException(String.format("Migration plan is mandatory for %s operation", OperationType.MIGRATE_PROCESS_INSTANCE));
        }
        migrationPlanDto.validate();
    }
}

