/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest.dto.operation;

import io.camunda.operate.webapp.rest.dto.RequestValidator;
import io.camunda.operate.webapp.rest.dto.operation.MigrationPlanDto;
import io.camunda.operate.webapp.rest.exception.InvalidRequestException;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@Schema(description="Migration plan for process instance migration operation")
public class MigrationPlanDto
implements RequestValidator {
    private String targetProcessDefinitionKey;
    private List<MappingInstruction> mappingInstructions;

    public String getTargetProcessDefinitionKey() {
        return this.targetProcessDefinitionKey;
    }

    public MigrationPlanDto setTargetProcessDefinitionKey(String targetProcessDefinitionKey) {
        this.targetProcessDefinitionKey = targetProcessDefinitionKey;
        return this;
    }

    public List<MappingInstruction> getMappingInstructions() {
        return this.mappingInstructions;
    }

    public MigrationPlanDto setMappingInstructions(List<MappingInstruction> mappingInstructions) {
        this.mappingInstructions = mappingInstructions;
        return this;
    }

    public void validate() {
        Long processDefinitionKey = null;
        try {
            long key = Long.parseLong(this.targetProcessDefinitionKey);
            if (key > 0L) {
                processDefinitionKey = key;
            }
        }
        catch (Exception key) {
            // empty catch block
        }
        if (processDefinitionKey == null) {
            throw new InvalidRequestException("Target process definition key must be a positive number.");
        }
        if (this.mappingInstructions == null || this.mappingInstructions.isEmpty()) {
            throw new InvalidRequestException("Mapping instructions are missing.");
        }
        boolean hasNullMappings = this.mappingInstructions.stream().anyMatch(Objects::isNull);
        if (hasNullMappings) {
            throw new InvalidRequestException("Mapping instructions cannot be null.");
        }
        boolean hasEmptyElements = this.mappingInstructions.stream().anyMatch(x -> StringUtils.isEmpty((CharSequence)x.getSourceElementId()) || StringUtils.isEmpty((CharSequence)x.getTargetElementId()));
        if (hasEmptyElements) {
            throw new InvalidRequestException("Mapping source and target elements cannot be empty.");
        }
    }

    public int hashCode() {
        return Objects.hash(this.targetProcessDefinitionKey, this.mappingInstructions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrationPlanDto that = (MigrationPlanDto)o;
        return Objects.equals(this.targetProcessDefinitionKey, that.targetProcessDefinitionKey) && Objects.equals(this.mappingInstructions, that.mappingInstructions);
    }
}

