/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest.dto.metadata;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.camunda.operate.entities.EventEntity;
import io.camunda.operate.entities.EventMetadataEntity;
import io.camunda.operate.entities.FlowNodeType;
import io.camunda.operate.webapp.rest.dto.metadata.FlowNodeInstanceMetadata;
import io.camunda.operate.webapp.rest.dto.metadata.FlowNodeInstanceMetadataDto;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class JobFlowNodeInstanceMetadataDto
extends FlowNodeInstanceMetadataDto
implements FlowNodeInstanceMetadata {
    private OffsetDateTime jobDeadline;
    private String jobType;
    private Integer jobRetries;
    private String jobWorker;
    private Map<String, String> jobCustomHeaders;

    public JobFlowNodeInstanceMetadataDto(String flowNodeId, String flowNodeInstanceId, FlowNodeType flowNodeType, OffsetDateTime startDate, OffsetDateTime endDate, EventEntity event) {
        super(flowNodeId, flowNodeInstanceId, flowNodeType, startDate, endDate, event);
        EventMetadataEntity eventMetadataEntity = event.getMetadata();
        if (eventMetadataEntity != null) {
            this.setJobCustomHeaders(eventMetadataEntity.getJobCustomHeaders()).setJobDeadline(eventMetadataEntity.getJobDeadline()).setJobRetries(eventMetadataEntity.getJobRetries()).setJobType(eventMetadataEntity.getJobType()).setJobWorker(eventMetadataEntity.getJobWorker());
        }
    }

    public JobFlowNodeInstanceMetadataDto() {
    }

    public String getJobType() {
        return this.jobType;
    }

    public JobFlowNodeInstanceMetadataDto setJobType(String jobType) {
        this.jobType = jobType;
        return this;
    }

    public Integer getJobRetries() {
        return this.jobRetries;
    }

    public JobFlowNodeInstanceMetadataDto setJobRetries(Integer jobRetries) {
        this.jobRetries = jobRetries;
        return this;
    }

    public String getJobWorker() {
        return this.jobWorker;
    }

    public JobFlowNodeInstanceMetadataDto setJobWorker(String jobWorker) {
        this.jobWorker = jobWorker;
        return this;
    }

    public OffsetDateTime getJobDeadline() {
        return this.jobDeadline;
    }

    public JobFlowNodeInstanceMetadataDto setJobDeadline(OffsetDateTime jobDeadline) {
        this.jobDeadline = jobDeadline;
        return this;
    }

    public Map<String, String> getJobCustomHeaders() {
        return this.jobCustomHeaders;
    }

    public JobFlowNodeInstanceMetadataDto setJobCustomHeaders(Map<String, String> jobCustomHeaders) {
        this.jobCustomHeaders = jobCustomHeaders;
        return this;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.jobDeadline, this.jobType, this.jobRetries, this.jobWorker, this.jobCustomHeaders);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JobFlowNodeInstanceMetadataDto that = (JobFlowNodeInstanceMetadataDto)o;
        return Objects.equals(this.jobDeadline, that.jobDeadline) && Objects.equals(this.jobType, that.jobType) && Objects.equals(this.jobRetries, that.jobRetries) && Objects.equals(this.jobWorker, that.jobWorker) && Objects.equals(this.jobCustomHeaders, that.jobCustomHeaders);
    }

    public String toString() {
        return "JobFlowNodeInstanceMetadataDto{jobDeadline=" + String.valueOf(this.jobDeadline) + ", jobType='" + this.jobType + "', jobRetries=" + this.jobRetries + ", jobWorker='" + this.jobWorker + "', jobCustomHeaders=" + String.valueOf(this.jobCustomHeaders) + "} " + super.toString();
    }
}

