/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest.dto.listview;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.util.LambdaExceptionUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortValuesWrapper
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SortValuesWrapper.class);
    public String value;
    public Class valueType;

    public SortValuesWrapper() {
    }

    public SortValuesWrapper(String value, Class valueType) {
        this.value = value;
        this.valueType = valueType;
    }

    public static SortValuesWrapper[] createFrom(Object[] sortValues, ObjectMapper objectMapper) {
        if (sortValues == null) {
            return null;
        }
        try {
            return (SortValuesWrapper[])Arrays.stream(sortValues).map(LambdaExceptionUtil.rethrowFunction(value -> new SortValuesWrapper(objectMapper.writeValueAsString(value), value.getClass()))).toArray(SortValuesWrapper[]::new);
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Unable to serialize sortValues. Error: " + e.getMessage(), (Throwable)e);
            throw new OperateRuntimeException((Throwable)e);
        }
    }

    public static Object[] convertSortValues(SortValuesWrapper[] sortValuesWrappers, ObjectMapper objectMapper) {
        if (sortValuesWrappers == null) {
            return null;
        }
        try {
            return Arrays.stream(sortValuesWrappers).map(LambdaExceptionUtil.rethrowFunction(value -> objectMapper.readValue(value.value.getBytes(), value.valueType))).toArray(Object[]::new);
        }
        catch (IOException e) {
            LOGGER.warn("Unable to deserialize sortValues. Error: " + e.getMessage(), (Throwable)e);
            throw new OperateRuntimeException((Throwable)e);
        }
    }

    public Object getValue() {
        return this.value;
    }

    public SortValuesWrapper setValue(String value) {
        this.value = value;
        return this;
    }

    public Class getValueType() {
        return this.valueType;
    }

    public SortValuesWrapper setValueType(Class valueType) {
        this.valueType = valueType;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.value, this.valueType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortValuesWrapper that = (SortValuesWrapper)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.valueType, that.valueType);
    }
}

