/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest.dto;

import io.camunda.operate.webapp.rest.dto.PaginatedQuery;
import io.camunda.operate.webapp.rest.dto.SortingDto;
import io.camunda.operate.webapp.rest.exception.InvalidRequestException;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Process instances variables request")
public class VariableRequestDto
extends PaginatedQuery<VariableRequestDto> {
    @Schema(description="Variable scope. Must be processInstanceId for process instance level variables.")
    private String scopeId;

    public String getScopeId() {
        return this.scopeId;
    }

    public VariableRequestDto setScopeId(String scopeId) {
        this.scopeId = scopeId;
        return this;
    }

    public VariableRequestDto setSorting(SortingDto sorting) {
        if (sorting != null) {
            throw new InvalidRequestException("Sorting is not supported.");
        }
        return this;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.scopeId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VariableRequestDto that = (VariableRequestDto)o;
        return Objects.equals(this.scopeId, that.scopeId);
    }

    public VariableRequestDto createCopy() {
        return ((VariableRequestDto)((VariableRequestDto)((VariableRequestDto)((VariableRequestDto)((VariableRequestDto)new VariableRequestDto().setSearchBefore(this.getSearchBefore())).setSearchAfter(this.getSearchAfter())).setPageSize(this.getPageSize())).setSearchAfterOrEqual(this.getSearchAfterOrEqual())).setSearchBeforeOrEqual(this.getSearchBeforeOrEqual())).setScopeId(this.scopeId);
    }

    public String toString() {
        return "VariableRequestDto{scopeId='" + this.scopeId + "'}";
    }
}

