/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest.dto;

import io.camunda.operate.entities.ProcessEntity;
import io.camunda.operate.store.ProcessStore;
import io.camunda.operate.webapp.rest.dto.DtoCreator;
import io.camunda.operate.webapp.rest.dto.ProcessDto;
import io.camunda.operate.webapp.rest.dto.ProcessGroupDto;
import io.camunda.operate.webapp.security.identity.PermissionsService;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * Exception performing whole class analysis ignored.
 */
@Schema(name="Process group object", description="Group of processes with the same bpmnProcessId with all versions included")
public class ProcessGroupDto {
    private String bpmnProcessId;
    private String tenantId;
    private String name;
    private Set<String> permissions;
    private List<ProcessDto> processes;

    public static List<ProcessGroupDto> createFrom(Map<ProcessStore.ProcessKey, List<ProcessEntity>> processesGrouped) {
        return ProcessGroupDto.createFrom(processesGrouped, null);
    }

    public static List<ProcessGroupDto> createFrom(Map<ProcessStore.ProcessKey, List<ProcessEntity>> processesGrouped, PermissionsService permissionsService) {
        ArrayList<ProcessGroupDto> groups = new ArrayList<ProcessGroupDto>();
        processesGrouped.values().stream().forEach(group -> {
            ProcessGroupDto groupDto = new ProcessGroupDto();
            ProcessEntity process0 = (ProcessEntity)group.get(0);
            groupDto.setBpmnProcessId(process0.getBpmnProcessId());
            groupDto.setTenantId(process0.getTenantId());
            groupDto.setName(process0.getName());
            groupDto.setPermissions(permissionsService == null ? new HashSet() : permissionsService.getProcessDefinitionPermission(process0.getBpmnProcessId()));
            groupDto.setProcesses(DtoCreator.create((List)group, ProcessDto.class));
            groups.add(groupDto);
        });
        groups.sort((Comparator<ProcessGroupDto>)new ProcessGroupComparator());
        return groups;
    }

    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    public void setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessId = bpmnProcessId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public ProcessGroupDto setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<String> permissions) {
        this.permissions = permissions;
    }

    public List<ProcessDto> getProcesses() {
        return this.processes;
    }

    public void setProcesses(List<ProcessDto> processes) {
        this.processes = processes;
    }

    public int hashCode() {
        return this.bpmnProcessId != null ? this.bpmnProcessId.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessGroupDto that = (ProcessGroupDto)o;
        return this.bpmnProcessId != null ? this.bpmnProcessId.equals(that.bpmnProcessId) : that.bpmnProcessId == null;
    }
}

