/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest;

import io.camunda.operate.webapp.InternalAPIErrorController;
import io.camunda.operate.webapp.reader.IncidentStatisticsReader;
import io.camunda.operate.webapp.rest.dto.incidents.IncidentsByErrorMsgStatisticsDto;
import io.camunda.operate.webapp.rest.dto.incidents.IncidentsByProcessGroupStatisticsDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Incidents statistics")
@RestController
@RequestMapping(value={"/api/incidents"})
public class IncidentRestService
extends InternalAPIErrorController {
    public static final String INCIDENT_URL = "/api/incidents";
    @Autowired
    private IncidentStatisticsReader incidentStatisticsReader;

    @Operation(summary="Get incident statistics for processes")
    @GetMapping(value={"/byProcess"})
    public Collection<IncidentsByProcessGroupStatisticsDto> getProcessAndIncidentsStatistics() {
        return this.incidentStatisticsReader.getProcessAndIncidentsStatistics();
    }

    @Operation(summary="Get incident statistics by error message")
    @GetMapping(value={"/byError"})
    public Collection<IncidentsByErrorMsgStatisticsDto> getIncidentStatisticsByError() {
        return this.incidentStatisticsReader.getIncidentStatisticsByError();
    }
}

