/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest;

import io.camunda.operate.entities.BatchOperationEntity;
import io.camunda.operate.entities.dmn.definition.DecisionDefinitionEntity;
import io.camunda.operate.util.rest.ValidLongId;
import io.camunda.operate.webapp.InternalAPIErrorController;
import io.camunda.operate.webapp.reader.DecisionReader;
import io.camunda.operate.webapp.rest.dto.DecisionRequestDto;
import io.camunda.operate.webapp.rest.dto.dmn.DecisionGroupDto;
import io.camunda.operate.webapp.rest.exception.NotAuthorizedException;
import io.camunda.operate.webapp.security.identity.IdentityPermission;
import io.camunda.operate.webapp.security.identity.PermissionsService;
import io.camunda.operate.webapp.writer.BatchOperationWriter;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Decisions")
@RestController
@RequestMapping(value={"/api/decisions"})
public class DecisionRestService
extends InternalAPIErrorController {
    public static final String DECISION_URL = "/api/decisions";
    @Autowired
    protected DecisionReader decisionReader;
    @Autowired(required=false)
    protected PermissionsService permissionsService;
    @Autowired
    private BatchOperationWriter batchOperationWriter;

    @Operation(summary="Get decision DMN XML")
    @GetMapping(path={"/{id}/xml"})
    public String getDecisionDiagram(@ValidLongId @PathVariable(value="id") String decisionDefinitionId) {
        Long decisionDefinitionKey = Long.valueOf(decisionDefinitionId);
        this.checkIdentityReadPermission(decisionDefinitionKey);
        return this.decisionReader.getDiagram(decisionDefinitionKey);
    }

    @Operation(summary="List decisions grouped by decisionId")
    @GetMapping(path={"/grouped"})
    @Deprecated
    public List<DecisionGroupDto> getDecisionsGrouped() {
        Map decisionsGrouped = this.decisionReader.getDecisionsGrouped(new DecisionRequestDto());
        return DecisionGroupDto.createFrom((Map)decisionsGrouped, (PermissionsService)this.permissionsService);
    }

    @Operation(summary="List decisions grouped by decisionId")
    @PostMapping(path={"/grouped"})
    public List<DecisionGroupDto> getDecisionsGrouped(@RequestBody DecisionRequestDto request) {
        Map decisionsGrouped = this.decisionReader.getDecisionsGrouped(request);
        return DecisionGroupDto.createFrom((Map)decisionsGrouped, (PermissionsService)this.permissionsService);
    }

    @Operation(summary="Delete decision definition and dependant resources")
    @DeleteMapping(path={"/{id}"})
    @PreAuthorize(value="hasPermission('write')")
    public BatchOperationEntity deleteDecisionDefinition(@ValidLongId @PathVariable(value="id") String decisionDefinitionId) {
        DecisionDefinitionEntity decisionDefinitionEntity = this.decisionReader.getDecision(Long.valueOf(decisionDefinitionId));
        this.checkIdentityDeletePermission(decisionDefinitionEntity.getDecisionId());
        return this.batchOperationWriter.scheduleDeleteDecisionDefinition(decisionDefinitionEntity);
    }

    private void checkIdentityReadPermission(Long decisionDefinitionKey) {
        String decisionId;
        if (this.permissionsService != null && !this.permissionsService.hasPermissionForDecision(decisionId = this.decisionReader.getDecision(decisionDefinitionKey).getDecisionId(), IdentityPermission.READ)) {
            throw new NotAuthorizedException(String.format("No read permission for decision %s", decisionId));
        }
    }

    private void checkIdentityDeletePermission(String decisionId) {
        if (this.permissionsService != null && !this.permissionsService.hasPermissionForDecision(decisionId, IdentityPermission.DELETE)) {
            throw new NotAuthorizedException(String.format("No delete permission for decision %s", decisionId));
        }
    }
}

