/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.OperateProfileService;
import io.camunda.operate.property.OperateProperties;
import jakarta.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ClientConfig {
    public boolean isEnterprise;
    public boolean canLogout;
    public String contextPath;
    public String organizationId;
    public String clusterId;
    public String mixpanelAPIHost;
    public String mixpanelToken;
    public boolean isLoginDelegated;
    public String tasklistUrl;
    public boolean resourcePermissionsEnabled;
    public boolean multiTenancyEnabled;
    @Autowired
    private OperateProfileService profileService;
    @Autowired
    private OperateProperties operateProperties;
    @Autowired
    private ServletContext context;

    public String asJson() {
        this.isEnterprise = this.operateProperties.isEnterprise();
        this.clusterId = this.operateProperties.getCloud().getClusterId();
        this.organizationId = this.operateProperties.getCloud().getOrganizationId();
        this.mixpanelAPIHost = this.operateProperties.getCloud().getMixpanelAPIHost();
        this.mixpanelToken = this.operateProperties.getCloud().getMixpanelToken();
        this.contextPath = this.context.getContextPath();
        this.canLogout = this.profileService.currentProfileCanLogout();
        this.isLoginDelegated = this.profileService.isLoginDelegated();
        this.tasklistUrl = this.operateProperties.getTasklistUrl();
        this.resourcePermissionsEnabled = this.operateProperties.getIdentity().isResourcePermissionsEnabled();
        this.multiTenancyEnabled = this.operateProperties.getMultiTenancy().isEnabled();
        try {
            return String.format("window.clientConfig = %s;", new ObjectMapper().writeValueAsString((Object)this));
        }
        catch (JsonProcessingException e) {
            return "window.clientConfig = {};";
        }
    }
}

