/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest;

import io.camunda.operate.webapp.InternalAPIErrorController;
import io.camunda.operate.webapp.rest.dto.UserDto;
import io.camunda.operate.webapp.rest.exception.UserNotFoundException;
import io.camunda.operate.webapp.security.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/authentications"})
public class AuthenticationRestService
extends InternalAPIErrorController {
    public static final String AUTHENTICATION_URL = "/api/authentications";
    public static final String USER_ENDPOINT = "/user";
    public static final String TOKEN_ENDPOINT = "/token";
    @Autowired
    private UserService userService;

    @GetMapping(path={"/user"})
    public UserDto getCurrentAuthentication() {
        try {
            return this.userService.getCurrentUser();
        }
        catch (UsernameNotFoundException e) {
            throw new UserNotFoundException("Current user couldn't be found", (Throwable)e);
        }
    }

    @GetMapping(path={"/token"})
    public String getCurrentUserToken() {
        return this.userService.getUserToken();
    }
}

