/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.reader;

import io.camunda.operate.entities.ProcessEntity;
import io.camunda.operate.store.ProcessStore;
import io.camunda.operate.webapp.rest.dto.ProcessRequestDto;
import io.camunda.operate.webapp.security.identity.IdentityPermission;
import io.camunda.operate.webapp.security.identity.PermissionsService;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProcessReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessReader.class);
    @Autowired
    private ProcessStore processStore;
    @Autowired(required=false)
    private PermissionsService permissionsService;

    public String getDiagram(Long processDefinitionKey) {
        return this.processStore.getDiagramByKey(processDefinitionKey);
    }

    public ProcessEntity getProcess(Long processDefinitionKey) {
        return this.processStore.getProcessByKey(processDefinitionKey);
    }

    public Map<ProcessStore.ProcessKey, List<ProcessEntity>> getProcessesGrouped(ProcessRequestDto request) {
        return this.processStore.getProcessesGrouped(request.getTenantId(), this.getAllowedProcessIdsOrNullForAll());
    }

    public Map<Long, ProcessEntity> getProcessesWithFields(int maxSize, String ... fields) {
        return this.processStore.getProcessesIdsToProcessesWithFields(this.getAllowedProcessIdsOrNullForAll(), maxSize, fields);
    }

    public Map<Long, ProcessEntity> getProcessesWithFields(String ... fields) {
        return this.getProcessesWithFields(1000, fields);
    }

    private Set<String> getAllowedProcessIdsOrNullForAll() {
        if (this.permissionsService == null) {
            return null;
        }
        PermissionsService.ResourcesAllowed allowed = this.permissionsService.getProcessesWithPermission(IdentityPermission.READ);
        return allowed == null || allowed.isAll() ? null : allowed.getIds();
    }
}

