/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.opensearch.reader;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.entities.VariableEntity;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.templates.TemplateDescriptor;
import io.camunda.operate.schema.templates.VariableTemplate;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import io.camunda.operate.util.CollectionUtil;
import io.camunda.operate.webapp.reader.OperationReader;
import io.camunda.operate.webapp.reader.VariableReader;
import io.camunda.operate.webapp.rest.dto.VariableDto;
import io.camunda.operate.webapp.rest.dto.VariableRequestDto;
import io.camunda.operate.webapp.rest.exception.NotFoundException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.opensearch.core.search.HitsMetadata;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchVariableReader
implements VariableReader {
    @Autowired
    private OperateProperties operateProperties;
    @Autowired
    private VariableTemplate variableTemplate;
    @Autowired
    private OperationReader operationReader;
    @Autowired
    private RichOpenSearchClient richOpenSearchClient;
    @Autowired
    private ObjectMapper objectMapper;

    public List<VariableDto> getVariables(String processInstanceId, VariableRequestDto request) {
        List response = this.queryVariables(processInstanceId, request);
        if (request.getSearchAfterOrEqual() != null || request.getSearchBeforeOrEqual() != null) {
            this.adjustResponse(response, processInstanceId, request);
        }
        if (!(response.isEmpty() || request.getSearchAfter() == null && request.getSearchAfterOrEqual() == null)) {
            VariableDto firstVar = (VariableDto)response.get(0);
            firstVar.setIsFirst(this.checkVarIsFirst(processInstanceId, request, firstVar.getId()));
        }
        return response;
    }

    public VariableDto getVariable(String id) {
        SearchRequest.Builder searchRequest = RequestDSL.searchRequestBuilder((TemplateDescriptor)this.variableTemplate).query(QueryDSL.withTenantCheck((Query)QueryDSL.ids((String[])new String[]{id})));
        HitsMetadata hits = this.richOpenSearchClient.doc().search(searchRequest, VariableEntity.class).hits();
        if (hits.total().value() != 1L) {
            throw new NotFoundException(String.format("Variable with id %s not found.", id));
        }
        return this.toVariableDto((VariableEntity)((Hit)hits.hits().get(0)).source());
    }

    public VariableDto getVariableByName(String processInstanceId, String scopeId, String variableName) {
        SearchRequest.Builder searchRequest = RequestDSL.searchRequestBuilder((TemplateDescriptor)this.variableTemplate).query(QueryDSL.constantScore((Query)QueryDSL.withTenantCheck((Query)QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)"processInstanceKey", (String)processInstanceId), QueryDSL.term((String)"scopeKey", (String)scopeId), QueryDSL.term((String)"name", (String)variableName)}))));
        HitsMetadata hits = this.richOpenSearchClient.doc().search(searchRequest, VariableEntity.class).hits();
        if (hits.total().value() > 0L) {
            return this.toVariableDto((VariableEntity)((Hit)hits.hits().get(0)).source());
        }
        return null;
    }

    private void adjustResponse(List<VariableDto> response, String processInstanceId, VariableRequestDto request) {
        String variableName = null;
        if (request.getSearchAfterOrEqual() != null) {
            variableName = (String)request.getSearchAfterOrEqual(this.objectMapper)[0];
        } else if (request.getSearchBeforeOrEqual() != null) {
            variableName = (String)request.getSearchBeforeOrEqual(this.objectMapper)[0];
        }
        VariableRequestDto newRequest = (VariableRequestDto)((VariableRequestDto)((VariableRequestDto)((VariableRequestDto)request.createCopy().setSearchAfter(null)).setSearchAfterOrEqual(null)).setSearchBefore(null)).setSearchBeforeOrEqual(null);
        List entities = this.queryVariables(processInstanceId, newRequest, variableName);
        if (!entities.isEmpty()) {
            VariableDto entity = (VariableDto)entities.get(0);
            entity.setIsFirst(false);
            if (request.getSearchAfterOrEqual() != null) {
                if (request.getPageSize() != null && response.size() == request.getPageSize().intValue()) {
                    response.remove(response.size() - 1);
                }
                response.add(0, entity);
            } else if (request.getSearchBeforeOrEqual() != null) {
                if (request.getPageSize() != null && response.size() == request.getPageSize().intValue()) {
                    response.remove(0);
                }
                response.add(entity);
            }
        }
    }

    private boolean checkVarIsFirst(String processInstanceId, VariableRequestDto query, String id) {
        VariableRequestDto newQuery = (VariableRequestDto)((VariableRequestDto)((VariableRequestDto)((VariableRequestDto)((VariableRequestDto)query.createCopy().setSearchAfter(null)).setSearchAfterOrEqual(null)).setSearchBefore(null)).setSearchBeforeOrEqual(null)).setPageSize(Integer.valueOf(1));
        List vars = this.queryVariables(processInstanceId, newQuery);
        if (!vars.isEmpty()) {
            return ((VariableDto)vars.get(0)).getId().equals(id);
        }
        return false;
    }

    private List<VariableDto> queryVariables(String processInstanceId, VariableRequestDto variableRequest) {
        return this.queryVariables(processInstanceId, variableRequest, null);
    }

    private List<VariableDto> queryVariables(String processInstanceId, VariableRequestDto request, String varName) {
        Long scopeKey = null;
        if (request.getScopeId() != null) {
            scopeKey = Long.valueOf(request.getScopeId());
        }
        SearchRequest.Builder req = RequestDSL.searchRequestBuilder((TemplateDescriptor)this.variableTemplate).query(QueryDSL.constantScore((Query)QueryDSL.withTenantCheck((Query)QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)"processInstanceKey", (String)processInstanceId), QueryDSL.term((String)"scopeKey", (Long)scopeKey), varName != null ? QueryDSL.term((String)"name", (String)varName) : null})))).source(QueryDSL.sourceExclude((String[])new String[]{"fullValue"}));
        this.applySorting(req, request);
        SearchResponse response = this.richOpenSearchClient.doc().search(req, VariableEntity.class);
        List<VariableEntity> variableEntities = response.hits().hits().stream().filter(hit -> hit.source() != null).map(hit -> ((VariableEntity)hit.source()).setSortValues(hit.sort().toArray())).toList();
        Map operations = this.operationReader.getUpdateOperationsPerVariableName(Long.valueOf(processInstanceId), scopeKey);
        List variables = VariableDto.createFrom(variableEntities, (Map)operations, (int)this.operateProperties.getImporter().getVariableSizeThreshold(), (ObjectMapper)this.objectMapper);
        if (!variables.isEmpty()) {
            if (request.getSearchBefore() != null || request.getSearchBeforeOrEqual() != null) {
                if (variables.size() <= request.getPageSize()) {
                    ((VariableDto)variables.get(variables.size() - 1)).setIsFirst(true);
                } else {
                    variables.remove(variables.size() - 1);
                }
                Collections.reverse(variables);
            } else if (request.getSearchAfter() == null && request.getSearchAfterOrEqual() == null) {
                ((VariableDto)variables.get(0)).setIsFirst(true);
            }
        }
        return variables;
    }

    private void applySorting(SearchRequest.Builder searchRequest, VariableRequestDto request) {
        boolean directSorting;
        boolean bl = directSorting = request.getSearchAfter() != null || request.getSearchAfterOrEqual() != null || request.getSearchBefore() == null && request.getSearchBeforeOrEqual() == null;
        if (directSorting) {
            searchRequest.sort(QueryDSL.sortOptions((String)"name", (SortOrder)SortOrder.Asc), new SortOptions[0]);
            if (request.getSearchAfter() != null) {
                searchRequest.searchAfter(CollectionUtil.toSafeListOfStrings((Object[])request.getSearchAfter(this.objectMapper)));
            } else if (request.getSearchAfterOrEqual() != null) {
                searchRequest.searchAfter(CollectionUtil.toSafeListOfStrings((Object[])request.getSearchAfterOrEqual(this.objectMapper)));
            }
            searchRequest.size(request.getPageSize());
        } else {
            searchRequest.sort(QueryDSL.sortOptions((String)"name", (SortOrder)SortOrder.Desc), new SortOptions[0]);
            if (request.getSearchBefore() != null) {
                searchRequest.searchAfter(CollectionUtil.toSafeListOfStrings((Object[])request.getSearchBefore(this.objectMapper)));
            } else if (request.getSearchBeforeOrEqual() != null) {
                searchRequest.searchAfter(CollectionUtil.toSafeListOfStrings((Object[])request.getSearchBeforeOrEqual(this.objectMapper)));
            }
            searchRequest.size(Integer.valueOf(request.getPageSize() + 1));
        }
    }

    private VariableDto toVariableDto(VariableEntity variableEntity) {
        return VariableDto.createFrom((VariableEntity)variableEntity, null, (boolean)true, (int)this.operateProperties.getImporter().getVariableSizeThreshold(), (ObjectMapper)this.objectMapper);
    }
}

