/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.opensearch.reader;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.entities.UserTaskEntity;
import io.camunda.operate.schema.templates.UserTaskTemplate;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import io.camunda.operate.webapp.opensearch.reader.OpensearchAbstractReader;
import io.camunda.operate.webapp.reader.UserTaskReader;
import java.util.List;
import java.util.Optional;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.opensearch.core.search.HitsMetadata;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchUserTaskReader
extends OpensearchAbstractReader
implements UserTaskReader {
    private final UserTaskTemplate userTaskTemplate;

    public OpensearchUserTaskReader(UserTaskTemplate userTaskTemplate) {
        this.userTaskTemplate = userTaskTemplate;
    }

    public List<UserTaskEntity> getUserTasks() {
        SearchRequest.Builder request = RequestDSL.searchRequestBuilder((String)this.userTaskTemplate.getAlias()).query(QueryDSL.withTenantCheck((Query)QueryDSL.matchAll()));
        return this.richOpenSearchClient.doc().searchValues(request, UserTaskEntity.class);
    }

    public Optional<UserTaskEntity> getUserTaskByFlowNodeInstanceKey(long flowNodeInstanceKey) {
        SearchRequest.Builder request = RequestDSL.searchRequestBuilder((String)this.userTaskTemplate.getAlias()).query(QueryDSL.withTenantCheck((Query)QueryDSL.term((String)"elementInstanceKey", (Long)flowNodeInstanceKey)));
        HitsMetadata hits = this.richOpenSearchClient.doc().search(request, UserTaskEntity.class).hits();
        if (hits.total().value() == 1L) {
            return Optional.of((UserTaskEntity)((Hit)hits.hits().get(0)).source());
        }
        return Optional.empty();
    }
}

