/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.opensearch.reader;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.entities.ProcessEntity;
import io.camunda.operate.entities.listview.ProcessInstanceState;
import io.camunda.operate.schema.templates.IncidentTemplate;
import io.camunda.operate.schema.templates.ListViewTemplate;
import io.camunda.operate.schema.templates.TemplateDescriptor;
import io.camunda.operate.store.opensearch.OpensearchIncidentStore;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.store.opensearch.dsl.AggregationDSL;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import io.camunda.operate.util.ConversionUtils;
import io.camunda.operate.webapp.opensearch.reader.OpensearchIncidentStatisticsReader;
import io.camunda.operate.webapp.reader.IncidentStatisticsReader;
import io.camunda.operate.webapp.reader.ProcessReader;
import io.camunda.operate.webapp.rest.dto.ProcessRequestDto;
import io.camunda.operate.webapp.rest.dto.incidents.IncidentByProcessStatisticsDto;
import io.camunda.operate.webapp.rest.dto.incidents.IncidentsByErrorMsgStatisticsDto;
import io.camunda.operate.webapp.rest.dto.incidents.IncidentsByProcessGroupStatisticsDto;
import io.camunda.operate.webapp.security.identity.IdentityPermission;
import io.camunda.operate.webapp.security.identity.PermissionsService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.CardinalityAggregation;
import org.opensearch.client.opensearch._types.aggregations.LongTermsBucket;
import org.opensearch.client.opensearch._types.aggregations.TermsAggregation;
import org.opensearch.client.opensearch._types.aggregations.TopHitsAggregation;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.search.Hit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchIncidentStatisticsReader
implements IncidentStatisticsReader {
    private static final String ERROR_MESSAGE = "errorMessages";
    private static final String GROUP_BY_ERROR_MESSAGE_HASH = "group_by_errorMessages";
    private static final String GROUP_BY_PROCESS_KEYS = "group_by_processDefinitionKeys";
    private static final String UNIQ_PROCESS_INSTANCES = "uniq_processInstances";
    private static final Aggregation COUNT_PROCESS_KEYS = AggregationDSL.termAggregation((String)"processDefinitionKey", (int)10000)._toAggregation();
    private static final Query INCIDENTS_QUERY = QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)"joinRelation", (String)"processInstance"), QueryDSL.term((String)"state", (String)ProcessInstanceState.ACTIVE.toString()), QueryDSL.term((String)"incident", (boolean)true)});
    @Autowired
    RichOpenSearchClient richOpenSearchClient;
    @Autowired
    private IncidentTemplate incidentTemplate;
    @Autowired
    private ListViewTemplate processInstanceTemplate;
    @Autowired
    private ProcessReader processReader;
    @Autowired(required=false)
    private PermissionsService permissionsService;

    public Set<IncidentsByProcessGroupStatisticsDto> getProcessAndIncidentsStatistics() {
        Map incidentsByProcessMap = this.updateActiveInstances(this.getIncidentsByProcess());
        return this.collectStatisticsForProcessGroups(incidentsByProcessMap);
    }

    public Set<IncidentsByErrorMsgStatisticsDto> getIncidentStatisticsByError() {
        TreeSet<IncidentsByErrorMsgStatisticsDto> result = new TreeSet<IncidentsByErrorMsgStatisticsDto>(IncidentsByErrorMsgStatisticsDto.COMPARATOR);
        Map processes = this.processReader.getProcessesWithFields(new String[]{"key", "name", "bpmnProcessId", "tenantId", "version"});
        Query query = this.permissionsService == null ? OpensearchIncidentStore.ACTIVE_INCIDENT_QUERY : QueryDSL.and((Query[])new Query[]{OpensearchIncidentStore.ACTIVE_INCIDENT_QUERY, this.createQueryForProcessesByPermission(IdentityPermission.READ)});
        CardinalityAggregation uniqueProcessInstances = AggregationDSL.cardinalityAggregation((String)"processInstanceKey");
        TermsAggregation groupByProcessKeys = AggregationDSL.termAggregation((String)"processDefinitionKey", (int)10000);
        TopHitsAggregation errorMessage = AggregationDSL.topHitsAggregation(List.of("errorMessage"), (int)1, (SortOptions[])new SortOptions[0]);
        TermsAggregation groupByErrorMessageHash = AggregationDSL.termAggregation((String)"errorMessageHash", (int)10000);
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder((TemplateDescriptor)this.incidentTemplate, (RequestDSL.QueryType)RequestDSL.QueryType.ONLY_RUNTIME).query(QueryDSL.withTenantCheck((Query)query)).aggregations(GROUP_BY_ERROR_MESSAGE_HASH, AggregationDSL.withSubaggregations((TermsAggregation)groupByErrorMessageHash, Map.of(ERROR_MESSAGE, errorMessage._toAggregation(), GROUP_BY_PROCESS_KEYS, AggregationDSL.withSubaggregations((TermsAggregation)groupByProcessKeys, Map.of(UNIQ_PROCESS_INSTANCES, uniqueProcessInstances._toAggregation())))));
        ((Aggregate)this.richOpenSearchClient.doc().searchAggregations(searchRequestBuilder).get(GROUP_BY_ERROR_MESSAGE_HASH)).lterms().buckets().array().forEach(bucket -> result.add(this.getIncidentsByErrorMsgStatistic(processes, bucket)));
        return result;
    }

    private List<LongTermsBucket> searchAggBuckets(Query query) {
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder((TemplateDescriptor)this.processInstanceTemplate, (RequestDSL.QueryType)RequestDSL.QueryType.ONLY_RUNTIME).query(QueryDSL.withTenantCheck((Query)query)).aggregations("processDefinitionKeys", COUNT_PROCESS_KEYS);
        return ((Aggregate)this.richOpenSearchClient.doc().searchAggregations(searchRequestBuilder).get("processDefinitionKeys")).lterms().buckets().array();
    }

    private Map<Long, IncidentByProcessStatisticsDto> getIncidentsByProcess() {
        return this.searchAggBuckets(QueryDSL.withTenantCheck((Query)INCIDENTS_QUERY)).stream().collect(Collectors.toMap(bucket -> Long.valueOf(bucket.key()), bucket -> new IncidentByProcessStatisticsDto(bucket.key(), bucket.docCount(), 0L)));
    }

    private Map<Long, IncidentByProcessStatisticsDto> updateActiveInstances(Map<Long, IncidentByProcessStatisticsDto> statistics) {
        HashMap<Long, IncidentByProcessStatisticsDto> results = new HashMap<Long, IncidentByProcessStatisticsDto>(statistics);
        Query query = QueryDSL.withTenantCheck((Query)QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)"state", (String)ProcessInstanceState.ACTIVE.toString()), QueryDSL.term((String)"joinRelation", (String)"processInstance")}));
        this.searchAggBuckets(query).forEach(bucket -> {
            Long processDefinitionKey = Long.valueOf(bucket.key());
            long runningCount = bucket.docCount();
            IncidentByProcessStatisticsDto statistic = (IncidentByProcessStatisticsDto)results.get(processDefinitionKey);
            if (statistic != null) {
                statistic.setActiveInstancesCount(runningCount - statistic.getInstancesWithActiveIncidentsCount());
            } else {
                statistic = new IncidentByProcessStatisticsDto(bucket.key(), 0L, runningCount);
            }
            results.put(processDefinitionKey, statistic);
        });
        return results;
    }

    private Set<IncidentsByProcessGroupStatisticsDto> collectStatisticsForProcessGroups(Map<Long, IncidentByProcessStatisticsDto> incidentsByProcessMap) {
        TreeSet<IncidentsByProcessGroupStatisticsDto> result = new TreeSet<IncidentsByProcessGroupStatisticsDto>(IncidentsByProcessGroupStatisticsDto.COMPARATOR);
        Map processGroups = this.processReader.getProcessesGrouped(new ProcessRequestDto());
        for (List processes : processGroups.values()) {
            IncidentsByProcessGroupStatisticsDto stat = new IncidentsByProcessGroupStatisticsDto();
            stat.setBpmnProcessId(((ProcessEntity)processes.get(0)).getBpmnProcessId());
            stat.setTenantId(((ProcessEntity)processes.get(0)).getTenantId());
            long activeInstancesCount = 0L;
            long instancesWithActiveIncidentsCount = 0L;
            long maxVersion = 0L;
            for (ProcessEntity processEntity : processes) {
                IncidentByProcessStatisticsDto statForProcess = incidentsByProcessMap.get(processEntity.getKey());
                if (statForProcess != null) {
                    activeInstancesCount += statForProcess.getActiveInstancesCount();
                    instancesWithActiveIncidentsCount += statForProcess.getInstancesWithActiveIncidentsCount();
                } else {
                    statForProcess = new IncidentByProcessStatisticsDto(ConversionUtils.toStringOrNull((Object)processEntity.getKey()), 0L, 0L);
                }
                statForProcess.setName(processEntity.getName());
                statForProcess.setBpmnProcessId(processEntity.getBpmnProcessId());
                statForProcess.setTenantId(processEntity.getTenantId());
                statForProcess.setVersion(processEntity.getVersion());
                stat.getProcesses().add(statForProcess);
                if ((long)processEntity.getVersion() <= maxVersion) continue;
                stat.setProcessName(processEntity.getName());
                maxVersion = processEntity.getVersion();
            }
            stat.setActiveInstancesCount(activeInstancesCount);
            stat.setInstancesWithActiveIncidentsCount(instancesWithActiveIncidentsCount);
            result.add(stat);
        }
        return result;
    }

    private Query createQueryForProcessesByPermission(IdentityPermission permission) {
        PermissionsService.ResourcesAllowed allowed = this.permissionsService.getProcessesWithPermission(permission);
        if (allowed == null) {
            return null;
        }
        return allowed.isAll() ? QueryDSL.matchAll() : QueryDSL.stringTerms((String)"bpmnProcessId", (Collection)allowed.getIds());
    }

    private IncidentsByErrorMsgStatisticsDto getIncidentsByErrorMsgStatistic(Map<Long, ProcessEntity> processes, LongTermsBucket errorMessageBucket) {
        ErrorMessage errorMessage = (ErrorMessage)((JsonData)((Hit)((Aggregate)errorMessageBucket.aggregations().get(ERROR_MESSAGE)).topHits().hits().hits().get(0)).source()).to(ErrorMessage.class);
        IncidentsByErrorMsgStatisticsDto processStatistics = new IncidentsByErrorMsgStatisticsDto(errorMessage.errorMessage());
        ((Aggregate)errorMessageBucket.aggregations().get(GROUP_BY_PROCESS_KEYS)).lterms().buckets().array().forEach(bucket -> {
            Long processDefinitionKey = Long.valueOf(bucket.key());
            long incidentsCount = ((Aggregate)bucket.aggregations().get(UNIQ_PROCESS_INSTANCES)).cardinality().value();
            if (processes.containsKey(processDefinitionKey)) {
                IncidentByProcessStatisticsDto statisticForProcess = new IncidentByProcessStatisticsDto(processDefinitionKey.toString(), errorMessage.errorMessage(), incidentsCount);
                ProcessEntity process = (ProcessEntity)processes.get(processDefinitionKey);
                statisticForProcess.setName(process.getName());
                statisticForProcess.setBpmnProcessId(process.getBpmnProcessId());
                statisticForProcess.setTenantId(process.getTenantId());
                statisticForProcess.setVersion(process.getVersion());
                processStatistics.getProcesses().add(statisticForProcess);
            }
            processStatistics.recordInstancesCount(incidentsCount);
        });
        return processStatistics;
    }
}

