/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.opensearch.reader;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.cache.ProcessCache;
import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.entities.FlowNodeInstanceEntity;
import io.camunda.operate.entities.FlowNodeState;
import io.camunda.operate.entities.FlowNodeType;
import io.camunda.operate.entities.IncidentEntity;
import io.camunda.operate.entities.dmn.DecisionInstanceState;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.schema.templates.DecisionInstanceTemplate;
import io.camunda.operate.schema.templates.FlowNodeInstanceTemplate;
import io.camunda.operate.schema.templates.IncidentTemplate;
import io.camunda.operate.schema.templates.TemplateDescriptor;
import io.camunda.operate.store.opensearch.OpensearchIncidentStore;
import io.camunda.operate.store.opensearch.client.sync.OpenSearchDocumentOperations;
import io.camunda.operate.store.opensearch.dsl.AggregationDSL;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import io.camunda.operate.util.TreePath;
import io.camunda.operate.webapp.data.IncidentDataHolder;
import io.camunda.operate.webapp.elasticsearch.reader.ProcessInstanceReader;
import io.camunda.operate.webapp.opensearch.reader.OpensearchAbstractReader;
import io.camunda.operate.webapp.opensearch.reader.OpensearchFlowNodeInstanceReader;
import io.camunda.operate.webapp.opensearch.reader.OpensearchIncidentReader;
import io.camunda.operate.webapp.reader.FlowNodeInstanceReader;
import io.camunda.operate.webapp.rest.FlowNodeInstanceMetadataBuilder;
import io.camunda.operate.webapp.rest.dto.FlowNodeStatisticsDto;
import io.camunda.operate.webapp.rest.dto.activity.FlowNodeInstanceDto;
import io.camunda.operate.webapp.rest.dto.activity.FlowNodeInstanceQueryDto;
import io.camunda.operate.webapp.rest.dto.activity.FlowNodeInstanceRequestDto;
import io.camunda.operate.webapp.rest.dto.activity.FlowNodeInstanceResponseDto;
import io.camunda.operate.webapp.rest.dto.activity.FlowNodeStateDto;
import io.camunda.operate.webapp.rest.dto.incidents.IncidentDto;
import io.camunda.operate.webapp.rest.dto.metadata.DecisionInstanceReferenceDto;
import io.camunda.operate.webapp.rest.dto.metadata.FlowNodeInstanceBreadcrumbEntryDto;
import io.camunda.operate.webapp.rest.dto.metadata.FlowNodeInstanceMetadata;
import io.camunda.operate.webapp.rest.dto.metadata.FlowNodeMetadataDto;
import io.camunda.operate.webapp.rest.dto.metadata.FlowNodeMetadataRequestDto;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.Buckets;
import org.opensearch.client.opensearch._types.aggregations.FilterAggregate;
import org.opensearch.client.opensearch._types.aggregations.FiltersBucket;
import org.opensearch.client.opensearch._types.aggregations.LongTermsAggregate;
import org.opensearch.client.opensearch._types.aggregations.LongTermsBucket;
import org.opensearch.client.opensearch._types.aggregations.StringTermsAggregate;
import org.opensearch.client.opensearch._types.aggregations.StringTermsBucket;
import org.opensearch.client.opensearch._types.aggregations.TermsAggregation;
import org.opensearch.client.opensearch._types.aggregations.TopHitsAggregate;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.opensearch.core.search.HitsMetadata;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchFlowNodeInstanceReader
extends OpensearchAbstractReader
implements FlowNodeInstanceReader {
    @Autowired
    private FlowNodeInstanceTemplate flowNodeInstanceTemplate;
    @Autowired
    private IncidentTemplate incidentTemplate;
    @Autowired
    private OpensearchIncidentReader incidentReader;
    @Autowired
    private DecisionInstanceTemplate decisionInstanceTemplate;
    @Autowired
    private ProcessInstanceReader processInstanceReader;
    @Autowired
    private ProcessCache processCache;
    @Autowired
    private FlowNodeInstanceMetadataBuilder flowNodeInstanceMetadataBuilder;

    public Map<String, FlowNodeInstanceResponseDto> getFlowNodeInstances(FlowNodeInstanceRequestDto request) {
        HashMap<String, FlowNodeInstanceResponseDto> response = new HashMap<String, FlowNodeInstanceResponseDto>();
        for (FlowNodeInstanceQueryDto query : request.getQueries()) {
            response.put(query.getTreePath(), this.getFlowNodeInstances(query));
        }
        return response;
    }

    public FlowNodeMetadataDto getFlowNodeMetadata(String processInstanceId, FlowNodeMetadataRequestDto request) {
        if (request.getFlowNodeId() != null) {
            return this.getMetadataByFlowNodeId(processInstanceId, request.getFlowNodeId(), request.getFlowNodeType());
        }
        if (request.getFlowNodeInstanceId() != null) {
            return this.getMetadataByFlowNodeInstanceId(request.getFlowNodeInstanceId());
        }
        return null;
    }

    public Map<String, FlowNodeStateDto> getFlowNodeStates(String processInstanceId) {
        String latestFlowNodeAggName = "latestFlowNode";
        String activeFlowNodesAggName = "activeFlowNodes";
        String activeFlowNodesBucketsAggName = "activeFlowNodesBuckets";
        String finishedFlowNodesAggName = "finishedFlowNodes";
        Query query = QueryDSL.constantScore((Query)QueryDSL.withTenantCheck((Query)QueryDSL.term((String)"processInstanceKey", (String)processInstanceId)));
        Aggregation notCompletedFlowNodesAggs = AggregationDSL.withSubaggregations((Query)QueryDSL.stringTerms((String)"state", List.of(FlowNodeState.ACTIVE.name(), FlowNodeState.TERMINATED.name())), Map.of("activeFlowNodesBuckets", AggregationDSL.withSubaggregations((TermsAggregation)AggregationDSL.termAggregation((String)"flowNodeId", (int)10000), Map.of("latestFlowNode", AggregationDSL.topHitsAggregation(List.of("state", "treePath"), (int)1, (SortOptions[])new SortOptions[]{QueryDSL.sortOptions((String)"startDate", (SortOrder)SortOrder.Desc)})._toAggregation()))));
        Aggregation finishedFlowNodesAggs = AggregationDSL.withSubaggregations((Query)QueryDSL.term((String)"state", (String)FlowNodeState.COMPLETED.name()), Map.of("finishedFlowNodesBuckets", AggregationDSL.termAggregation((String)"flowNodeId", (int)10000)._toAggregation()));
        Aggregation incidentsAggs = AggregationDSL.withSubaggregations((Query)QueryDSL.term((String)"incident", (boolean)true), Map.of("aggIncidentPaths", AggregationDSL.termAggregation((String)"treePath", (int)10000)._toAggregation()));
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder((TemplateDescriptor)this.flowNodeInstanceTemplate).query(query).aggregations(Map.of("activeFlowNodes", notCompletedFlowNodesAggs, "incidents", incidentsAggs, "finishedFlowNodes", finishedFlowNodesAggs)).size(Integer.valueOf(0));
        Map aggregates = this.richOpenSearchClient.doc().searchAggregations(searchRequestBuilder);
        Set incidentPaths = this.getIncidentPaths(((Aggregate)aggregates.get("incidents")).filter());
        Set finishedFlowNodes = this.collectFinishedFlowNodes(((Aggregate)aggregates.get("finishedFlowNodes")).filter());
        StringTermsAggregate flowNodesAgg = ((Aggregate)((Aggregate)aggregates.get("activeFlowNodes")).filter().aggregations().get("activeFlowNodesBuckets")).sterms();
        HashMap<String, FlowNodeStateDto> result = new HashMap<String, FlowNodeStateDto>();
        if (flowNodesAgg != null) {
            for (StringTermsBucket bucket : flowNodesAgg.buckets().array()) {
                FlowNodeResult lastFlowNode = (FlowNodeResult)((JsonData)((Hit)((Aggregate)bucket.aggregations().get("latestFlowNode")).topHits().hits().hits().get(0)).source()).to(FlowNodeResult.class);
                FlowNodeStateDto flowNodeState = FlowNodeStateDto.valueOf((String)lastFlowNode.state());
                if (flowNodeState == FlowNodeStateDto.ACTIVE && incidentPaths.contains(lastFlowNode.treePath())) {
                    flowNodeState = FlowNodeStateDto.INCIDENT;
                }
                result.put(bucket.key(), flowNodeState);
            }
        }
        for (String finishedFlowNodeId : finishedFlowNodes) {
            if (result.get(finishedFlowNodeId) != null) continue;
            result.put(finishedFlowNodeId, FlowNodeStateDto.COMPLETED);
        }
        return result;
    }

    public List<Long> getFlowNodeInstanceKeysByIdAndStates(Long processInstanceId, String flowNodeId, List<FlowNodeState> states) {
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder((String)this.flowNodeInstanceTemplate.getAlias()).query(QueryDSL.withTenantCheck((Query)QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)"flowNodeId", (String)flowNodeId), QueryDSL.term((String)"processInstanceKey", (Long)processInstanceId), QueryDSL.stringTerms((String)"state", states.stream().map(Enum::name).toList())}))).source(QueryDSL.sourceInclude((String[])new String[]{"id"}));
        return this.richOpenSearchClient.doc().searchValues(searchRequestBuilder, Result.class).stream().map(r -> Long.parseLong(r.id())).toList();
    }

    public Collection<FlowNodeStatisticsDto> getFlowNodeStatisticsForProcessInstance(Long processInstanceId) {
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder((TemplateDescriptor)this.flowNodeInstanceTemplate).query(QueryDSL.constantScore((Query)QueryDSL.withTenantCheck((Query)QueryDSL.term((String)"processInstanceKey", (Long)processInstanceId)))).aggregations("flowNodeIdAgg", AggregationDSL.withSubaggregations((TermsAggregation)AggregationDSL.termAggregation((String)"flowNodeId", (int)10000), Map.of("countIncident", QueryDSL.term((String)"incident", (boolean)true)._toAggregation(), "countCanceled", QueryDSL.and((Query[])new Query[]{QueryDSL.not((Query[])new Query[]{QueryDSL.term((String)"type", (String)FlowNodeType.MULTI_INSTANCE_BODY.name())}), QueryDSL.term((String)"state", (String)FlowNodeState.TERMINATED.name())})._toAggregation(), "countCompleted", QueryDSL.and((Query[])new Query[]{QueryDSL.not((Query[])new Query[]{QueryDSL.term((String)"type", (String)FlowNodeType.MULTI_INSTANCE_BODY.name())}), QueryDSL.term((String)"state", (String)FlowNodeState.COMPLETED.name())})._toAggregation(), "countActive", QueryDSL.and((Query[])new Query[]{QueryDSL.not((Query[])new Query[]{QueryDSL.term((String)"type", (String)FlowNodeType.MULTI_INSTANCE_BODY.name())}), QueryDSL.term((String)"state", (String)FlowNodeState.ACTIVE.name()), QueryDSL.term((String)"incident", (boolean)false)})._toAggregation()))).size(Integer.valueOf(0));
        return ((Aggregate)this.richOpenSearchClient.doc().searchAggregations(searchRequestBuilder).get("flowNodeIdAgg")).sterms().buckets().array().stream().map(entry -> new FlowNodeStatisticsDto().setActivityId(entry.key()).setCanceled(Long.valueOf(((Aggregate)entry.aggregations().get("countCanceled")).filter().docCount())).setIncidents(Long.valueOf(((Aggregate)entry.aggregations().get("countIncident")).filter().docCount())).setCompleted(Long.valueOf(((Aggregate)entry.aggregations().get("countCompleted")).filter().docCount())).setActive(Long.valueOf(((Aggregate)entry.aggregations().get("countActive")).filter().docCount()))).toList();
    }

    public List<FlowNodeInstanceEntity> getAllFlowNodeInstances(Long processInstanceKey) {
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder((TemplateDescriptor)this.flowNodeInstanceTemplate).query(QueryDSL.constantScore((Query)QueryDSL.withTenantCheck((Query)QueryDSL.term((String)"processInstanceKey", (Long)processInstanceKey)))).sort(QueryDSL.sortOptions((String)"position", (SortOrder)SortOrder.Asc), new SortOptions[0]);
        return this.richOpenSearchClient.doc().scrollValues(searchRequestBuilder, FlowNodeInstanceEntity.class);
    }

    private FlowNodeInstanceResponseDto getFlowNodeInstances(FlowNodeInstanceQueryDto request) {
        FlowNodeInstanceResponseDto response = this.queryFlowNodeInstances(request);
        if (request.getSearchAfterOrEqual() != null || request.getSearchBeforeOrEqual() != null) {
            this.adjustResponse(response, request);
        }
        return response;
    }

    private void adjustResponse(FlowNodeInstanceResponseDto response, FlowNodeInstanceQueryDto request) {
        String flowNodeInstanceId = null;
        if (request.getSearchAfterOrEqual() != null) {
            flowNodeInstanceId = (String)request.getSearchAfterOrEqual(this.objectMapper)[1];
        } else if (request.getSearchBeforeOrEqual() != null) {
            flowNodeInstanceId = (String)request.getSearchBeforeOrEqual(this.objectMapper)[1];
        }
        FlowNodeInstanceQueryDto newRequest = request.createCopy().setSearchAfter(null).setSearchAfterOrEqual(null).setSearchBefore(null).setSearchBeforeOrEqual(null);
        List entities = this.queryFlowNodeInstances(newRequest, flowNodeInstanceId).getChildren();
        if (entities.size() > 0) {
            FlowNodeInstanceDto entity = (FlowNodeInstanceDto)entities.get(0);
            List children = response.getChildren();
            if (request.getSearchAfterOrEqual() != null) {
                if (request.getPageSize() != null && children.size() == request.getPageSize().intValue()) {
                    children.remove(children.size() - 1);
                }
                children.add(0, entity);
            } else if (request.getSearchBeforeOrEqual() != null) {
                if (request.getPageSize() != null && children.size() == request.getPageSize().intValue()) {
                    children.remove(0);
                }
                children.add(entity);
            }
        }
    }

    private FlowNodeInstanceResponseDto queryFlowNodeInstances(FlowNodeInstanceQueryDto flowNodeInstanceRequest) {
        return this.queryFlowNodeInstances(flowNodeInstanceRequest, null);
    }

    private FlowNodeInstanceResponseDto queryFlowNodeInstances(FlowNodeInstanceQueryDto flowNodeInstanceRequest, String flowNodeInstanceId) {
        String processInstanceId = flowNodeInstanceRequest.getProcessInstanceId();
        String parentTreePath = flowNodeInstanceRequest.getTreePath();
        int level = parentTreePath.split("/").length;
        Query idsQuery = flowNodeInstanceId != null ? QueryDSL.ids((String[])new String[]{flowNodeInstanceId}) : null;
        Query query = QueryDSL.withTenantCheck((Query)QueryDSL.constantScore((Query)QueryDSL.term((String)"processInstanceKey", (String)processInstanceId)));
        Aggregation runningParentsAgg = QueryDSL.and((Query[])new Query[]{QueryDSL.not((Query[])new Query[]{QueryDSL.exists((String)"endDate")}), QueryDSL.prefix((String)"treePath", (String)parentTreePath), QueryDSL.term((String)"level", (Integer)(level - 1))})._toAggregation();
        Query postFilter = QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)"level", (Integer)level), QueryDSL.prefix((String)"treePath", (String)parentTreePath), idsQuery});
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder((TemplateDescriptor)this.flowNodeInstanceTemplate).query(query).aggregations("running", runningParentsAgg).postFilter(postFilter);
        if (flowNodeInstanceRequest.getPageSize() != null) {
            searchRequestBuilder.size(flowNodeInstanceRequest.getPageSize());
        }
        this.applySorting(searchRequestBuilder, flowNodeInstanceRequest);
        try {
            FlowNodeInstanceResponseDto response = flowNodeInstanceRequest.getPageSize() != null ? this.getOnePage(searchRequestBuilder, processInstanceId) : this.scrollAllSearchHits(searchRequestBuilder, processInstanceId);
            if (level == 1) {
                response.setRunning(null);
            }
            if (flowNodeInstanceRequest.getSearchBefore() != null || flowNodeInstanceRequest.getSearchBeforeOrEqual() != null) {
                Collections.reverse(response.getChildren());
            }
            return response;
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining all flow node instances: %s", e.getMessage());
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    private FlowNodeInstanceResponseDto scrollAllSearchHits(SearchRequest.Builder searchRequestBuilder, String processInstanceId) throws IOException {
        OpenSearchDocumentOperations.AggregatedResult response = this.richOpenSearchClient.doc().scrollHits(searchRequestBuilder, FlowNodeInstanceEntity.class);
        List<FlowNodeInstanceEntity> children = response.values().stream().map(hit -> {
            FlowNodeInstanceEntity entity = (FlowNodeInstanceEntity)hit.source();
            entity.setSortValues(hit.sort().toArray());
            return entity;
        }).toList();
        boolean runningParent = this.isRunningParent(response.aggregates());
        this.markHasIncident(processInstanceId, children);
        return new FlowNodeInstanceResponseDto(Boolean.valueOf(runningParent), FlowNodeInstanceDto.createFrom(children, (ObjectMapper)this.objectMapper));
    }

    private void applySorting(SearchRequest.Builder searchRequestBuilder, FlowNodeInstanceQueryDto request) {
        boolean directSorting = request.getSearchAfter() != null || request.getSearchAfterOrEqual() != null || request.getSearchBefore() == null && request.getSearchBeforeOrEqual() == null;
        Function<Object[], List> toStrings = objects -> Arrays.stream(objects).map(Object::toString).toList();
        if (directSorting) {
            searchRequestBuilder.sort(QueryDSL.sortOptions((String)"startDate", (SortOrder)SortOrder.Asc), new SortOptions[]{QueryDSL.sortOptions((String)"id", (SortOrder)SortOrder.Asc)});
            if (request.getSearchAfter() != null) {
                searchRequestBuilder.searchAfter(toStrings.apply(request.getSearchAfter(this.objectMapper)));
            } else if (request.getSearchAfterOrEqual() != null) {
                searchRequestBuilder.searchAfter(toStrings.apply(request.getSearchAfterOrEqual(this.objectMapper)));
            }
        } else {
            searchRequestBuilder.sort(QueryDSL.sortOptions((String)"startDate", (SortOrder)SortOrder.Desc), new SortOptions[]{QueryDSL.sortOptions((String)"id", (SortOrder)SortOrder.Desc)});
            if (request.getSearchBefore() != null) {
                searchRequestBuilder.searchAfter(toStrings.apply(request.getSearchBefore(this.objectMapper)));
            } else if (request.getSearchBeforeOrEqual() != null) {
                searchRequestBuilder.searchAfter(toStrings.apply(request.getSearchBeforeOrEqual(this.objectMapper)));
            }
        }
    }

    private FlowNodeInstanceResponseDto getOnePage(SearchRequest.Builder searchRequestBuilder, String processInstanceId) throws IOException {
        SearchResponse response = this.richOpenSearchClient.doc().search(searchRequestBuilder, FlowNodeInstanceEntity.class);
        boolean runningParent = this.isRunningParent(response.aggregations());
        List<FlowNodeInstanceEntity> children = response.hits().hits().stream().map(hit -> {
            FlowNodeInstanceEntity entity = (FlowNodeInstanceEntity)hit.source();
            entity.setSortValues(hit.sort().toArray());
            return entity;
        }).toList();
        this.markHasIncident(processInstanceId, children);
        return new FlowNodeInstanceResponseDto(Boolean.valueOf(runningParent), FlowNodeInstanceDto.createFrom(children, (ObjectMapper)this.objectMapper));
    }

    private void markHasIncident(String processInstanceId, List<FlowNodeInstanceEntity> flowNodeInstances) {
        if (flowNodeInstances == null || flowNodeInstances.isEmpty()) {
            return;
        }
        Map<String, Query> filters = flowNodeInstances.stream().filter(arg_0 -> this.flowNodeInstanceIsRunningOrIsNotMarked(arg_0)).collect(Collectors.toMap(flowNodeInstance -> flowNodeInstance.getId(), flowNodeInstance -> QueryDSL.and((Query[])new Query[]{QueryDSL.prefix((String)"treePath", (String)flowNodeInstance.getTreePath()), QueryDSL.term((String)"incident", (boolean)true)})));
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder((TemplateDescriptor)this.flowNodeInstanceTemplate).query(QueryDSL.withTenantCheck((Query)QueryDSL.term((String)"processInstanceKey", (String)processInstanceId))).size(Integer.valueOf(0)).aggregations("numberOfIncidentsForTreePath", AggregationDSL.filtersAggregation(filters)._toAggregation());
        Map<String, Long> flowNodeIdIncidents = ((Aggregate)this.richOpenSearchClient.doc().searchAggregations(searchRequestBuilder).get("numberOfIncidentsForTreePath")).filters().buckets().keyed().entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((FiltersBucket)entry.getValue()).docCount()));
        for (FlowNodeInstanceEntity flowNodeInstance2 : flowNodeInstances) {
            Long count = flowNodeIdIncidents.getOrDefault(flowNodeInstance2.getId(), 0L);
            if (count <= 0L) continue;
            flowNodeInstance2.setIncident(true);
        }
    }

    private boolean flowNodeInstanceIsRunningOrIsNotMarked(FlowNodeInstanceEntity flowNodeInstance) {
        return flowNodeInstance.getEndDate() == null || !flowNodeInstance.isIncident();
    }

    private boolean isRunningParent(Map<String, Aggregate> aggs) {
        Aggregate filterAggs = aggs.get("running");
        return filterAggs != null && filterAggs.filter().docCount() > 0L;
    }

    private FlowNodeMetadataDto getMetadataByFlowNodeInstanceId(String flowNodeInstanceId) {
        FlowNodeInstanceEntity flowNodeInstance = this.getFlowNodeInstanceEntity(flowNodeInstanceId);
        FlowNodeMetadataDto result = new FlowNodeMetadataDto();
        result.setInstanceMetadata(this.buildInstanceMetadata(flowNodeInstance));
        result.setFlowNodeInstanceId(flowNodeInstanceId);
        result.setBreadcrumb(this.buildBreadcrumb(flowNodeInstance.getTreePath(), flowNodeInstance.getFlowNodeId(), flowNodeInstance.getLevel()));
        this.searchForIncidents(result, String.valueOf(flowNodeInstance.getProcessInstanceKey()), flowNodeInstance.getFlowNodeId(), flowNodeInstance.getId(), flowNodeInstance.getType());
        return result;
    }

    private List<FlowNodeInstanceBreadcrumbEntryDto> buildBreadcrumb(String treePath, String flowNodeId, int level) {
        int lastSeparatorIndex = treePath.lastIndexOf("/");
        String prefixTreePath = lastSeparatorIndex > -1 ? treePath.substring(0, lastSeparatorIndex) : treePath;
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder((TemplateDescriptor)this.flowNodeInstanceTemplate).query(QueryDSL.constantScore((Query)QueryDSL.withTenantCheck((Query)QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)"flowNodeId", (String)flowNodeId), QueryDSL.prefix((String)"treePath", (String)prefixTreePath), QueryDSL.lte((String)"level", (Object)level)})))).source(s -> s.fetch(Boolean.valueOf(false))).size(Integer.valueOf(0)).aggregations("levelsAgg", this.getLevelsAggs());
        Buckets buckets = ((Aggregate)this.richOpenSearchClient.doc().searchAggregations(searchRequestBuilder).get("levelsAgg")).lterms().buckets();
        return this.buildBreadcrumbForFlowNodeId(buckets, level);
    }

    private FlowNodeInstanceEntity getFlowNodeInstanceEntity(String flowNodeInstanceId) {
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder((TemplateDescriptor)this.flowNodeInstanceTemplate).query(QueryDSL.constantScore((Query)QueryDSL.withTenantCheck((Query)QueryDSL.term((String)"id", (String)flowNodeInstanceId))));
        List hits = this.richOpenSearchClient.doc().search(searchRequestBuilder, FlowNodeInstanceEntity.class).hits().hits();
        if (hits.isEmpty()) {
            throw new OperateRuntimeException("No data found for flow node instance.");
        }
        return (FlowNodeInstanceEntity)((Hit)hits.get(0)).source();
    }

    private FlowNodeMetadataDto getMetadataByFlowNodeId(String processInstanceId, String flowNodeId, FlowNodeType flowNodeType) {
        SearchResponse response;
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder((TemplateDescriptor)this.flowNodeInstanceTemplate).query(QueryDSL.constantScore((Query)QueryDSL.withTenantCheck((Query)QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)"processInstanceKey", (String)processInstanceId), QueryDSL.term((String)"flowNodeId", (String)flowNodeId)})))).sort(QueryDSL.sortOptions((String)"level", (SortOrder)SortOrder.Asc), new SortOptions[0]).aggregations("levelsAgg", this.getLevelsAggs()).size(Integer.valueOf(1));
        if (flowNodeType != null) {
            searchRequestBuilder.postFilter(QueryDSL.term((String)"type", (String)flowNodeType.name()));
        }
        if ((response = this.richOpenSearchClient.doc().search(searchRequestBuilder, FlowNodeInstanceEntity.class)).hits().hits().isEmpty()) {
            throw new OperateRuntimeException("No data found for flow node instance.");
        }
        FlowNodeMetadataDto result = new FlowNodeMetadataDto();
        FlowNodeInstanceEntity flowNodeInstance = (FlowNodeInstanceEntity)((Hit)response.hits().hits().get(0)).source();
        LongTermsAggregate levelsAgg = ((Aggregate)response.aggregations().get("levelsAgg")).lterms();
        if (levelsAgg != null && levelsAgg.buckets() != null && !levelsAgg.buckets().array().isEmpty()) {
            LongTermsBucket bucketCurrentLevel = this.getBucketFromLevel(levelsAgg.buckets(), flowNodeInstance.getLevel());
            if (bucketCurrentLevel.docCount() == 1L) {
                result.setInstanceMetadata(this.buildInstanceMetadata(flowNodeInstance));
                result.setFlowNodeInstanceId(flowNodeInstance.getId());
                result.setBreadcrumb(this.buildBreadcrumbForFlowNodeId(levelsAgg.buckets(), flowNodeInstance.getLevel()));
                this.searchForIncidents(result, String.valueOf(flowNodeInstance.getProcessInstanceKey()), flowNodeInstance.getFlowNodeId(), flowNodeInstance.getId(), flowNodeInstance.getType());
            } else {
                result.setInstanceCount(Long.valueOf(bucketCurrentLevel.docCount()));
                result.setFlowNodeId(flowNodeInstance.getFlowNodeId());
                result.setFlowNodeType(flowNodeInstance.getType());
                this.searchForIncidentsByFlowNodeIdAndType(result, String.valueOf(flowNodeInstance.getProcessInstanceKey()), flowNodeInstance.getFlowNodeId(), flowNodeInstance.getType());
            }
        }
        return result;
    }

    private LongTermsBucket getBucketFromLevel(Buckets<LongTermsBucket> buckets, int level) {
        return buckets.array().stream().filter(b -> Integer.valueOf(b.key()) == level).findFirst().get();
    }

    private void searchForIncidentsByFlowNodeIdAndType(FlowNodeMetadataDto flowNodeMetadata, String processInstanceId, String flowNodeId, FlowNodeType flowNodeType) {
        String treePath = this.processInstanceReader.getProcessInstanceTreePath(processInstanceId);
        String flowNodeInstancesTreePath = new TreePath(treePath).appendFlowNode(flowNodeId).toString();
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder((TemplateDescriptor)this.incidentTemplate, (RequestDSL.QueryType)RequestDSL.QueryType.ONLY_RUNTIME).query(QueryDSL.constantScore((Query)QueryDSL.withTenantCheck((Query)QueryDSL.and((Query[])new Query[]{OpensearchIncidentStore.ACTIVE_INCIDENT_QUERY, QueryDSL.term((String)"treePath", (String)flowNodeInstancesTreePath)}))));
        HitsMetadata hitsMeta = this.richOpenSearchClient.doc().search(searchRequestBuilder, IncidentEntity.class).hits();
        flowNodeMetadata.setIncidentCount(Long.valueOf(hitsMeta.total().value()));
        if (hitsMeta.total().value() == 1L) {
            IncidentEntity incidentEntity = (IncidentEntity)((Hit)hitsMeta.hits().get(0)).source();
            Map incData = this.incidentReader.collectFlowNodeDataForPropagatedIncidents(List.of(incidentEntity), processInstanceId, treePath);
            DecisionInstanceReferenceDto rootCauseDecision = flowNodeType == FlowNodeType.BUSINESS_RULE_TASK ? this.findRootCauseDecision(incidentEntity.getFlowNodeInstanceKey()) : null;
            IncidentDto incidentDto = IncidentDto.createFrom((IncidentEntity)incidentEntity, Map.of(incidentEntity.getProcessDefinitionKey(), this.processCache.getProcessNameOrBpmnProcessId(incidentEntity.getProcessDefinitionKey(), "Unknown process")), (IncidentDataHolder)((IncidentDataHolder)incData.get(incidentEntity.getId())), (DecisionInstanceReferenceDto)rootCauseDecision);
            flowNodeMetadata.setIncident(incidentDto);
        }
    }

    private void searchForIncidents(FlowNodeMetadataDto flowNodeMetadata, String processInstanceId, String flowNodeId, String flowNodeInstanceId, FlowNodeType flowNodeType) {
        String treePath = this.processInstanceReader.getProcessInstanceTreePath(processInstanceId);
        String incidentTreePath = new TreePath(treePath).appendFlowNode(flowNodeId).appendFlowNodeInstance(flowNodeInstanceId).toString();
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder((TemplateDescriptor)this.incidentTemplate, (RequestDSL.QueryType)RequestDSL.QueryType.ONLY_RUNTIME).query(QueryDSL.constantScore((Query)QueryDSL.withTenantCheck((Query)QueryDSL.and((Query[])new Query[]{OpensearchIncidentStore.ACTIVE_INCIDENT_QUERY, QueryDSL.term((String)"treePath", (String)incidentTreePath)}))));
        HitsMetadata hitsMeta = this.richOpenSearchClient.doc().search(searchRequestBuilder, IncidentEntity.class).hits();
        flowNodeMetadata.setIncidentCount(Long.valueOf(hitsMeta.total().value()));
        if (hitsMeta.total().value() == 1L) {
            IncidentEntity incidentEntity = (IncidentEntity)((Hit)hitsMeta.hits().get(0)).source();
            Map incData = this.incidentReader.collectFlowNodeDataForPropagatedIncidents(List.of(incidentEntity), processInstanceId, treePath);
            DecisionInstanceReferenceDto rootCauseDecision = null;
            if (flowNodeType.equals((Object)FlowNodeType.BUSINESS_RULE_TASK)) {
                rootCauseDecision = this.findRootCauseDecision(incidentEntity.getFlowNodeInstanceKey());
            }
            IncidentDto incidentDto = IncidentDto.createFrom((IncidentEntity)incidentEntity, Map.of(incidentEntity.getProcessDefinitionKey(), this.processCache.getProcessNameOrBpmnProcessId(incidentEntity.getProcessDefinitionKey(), "Unknown process")), (IncidentDataHolder)((IncidentDataHolder)incData.get(incidentEntity.getId())), (DecisionInstanceReferenceDto)rootCauseDecision);
            flowNodeMetadata.setIncident(incidentDto);
        }
    }

    private DecisionInstanceReferenceDto findRootCauseDecision(Long flowNodeInstanceKey) {
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder((TemplateDescriptor)this.decisionInstanceTemplate).query(QueryDSL.withTenantCheck((Query)QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)"elementInstanceKey", (Long)flowNodeInstanceKey), QueryDSL.term((String)"state", (String)DecisionInstanceState.FAILED.name())}))).sort(QueryDSL.sortOptions((String)"evaluationDate", (SortOrder)SortOrder.Desc), new SortOptions[0]).size(Integer.valueOf(1)).source(QueryDSL.sourceInclude((String[])new String[]{"decisionName", "decisionId"}));
        List hits = this.richOpenSearchClient.doc().search(searchRequestBuilder, Result.class).hits().hits();
        if (hits.isEmpty()) {
            return null;
        }
        Result result = (Result)((Hit)hits.get(0)).source();
        String decisionName = result.decisionName() != null ? result.decisionName() : result.decisionId();
        return new DecisionInstanceReferenceDto().setDecisionName(decisionName).setInstanceId(((Hit)hits.get(0)).id());
    }

    private List<FlowNodeInstanceBreadcrumbEntryDto> buildBreadcrumbForFlowNodeId(Buckets<LongTermsBucket> buckets, int currentInstanceLevel) {
        if (buckets.array().size() == 0) {
            return new ArrayList<FlowNodeInstanceBreadcrumbEntryDto>();
        }
        ArrayList<FlowNodeInstanceBreadcrumbEntryDto> breadcrumb = new ArrayList<FlowNodeInstanceBreadcrumbEntryDto>();
        FlowNodeType firstBucketFlowNodeType = this.getFirstBucketFlowNodeType(buckets);
        if (firstBucketFlowNodeType != null && firstBucketFlowNodeType.equals((Object)FlowNodeType.MULTI_INSTANCE_BODY) || this.getBucketFromLevel(buckets, currentInstanceLevel).docCount() > 1L) {
            for (LongTermsBucket levelBucket : buckets.array()) {
                TopHitsAggregate levelTopHits = ((Aggregate)levelBucket.aggregations().get("levelsTopHitsAgg")).topHits();
                Result result = (Result)((JsonData)((Hit)levelTopHits.hits().hits().get(0)).source()).to(Result.class);
                if (result.level > currentInstanceLevel) continue;
                breadcrumb.add(new FlowNodeInstanceBreadcrumbEntryDto(result.flowNodeId, FlowNodeType.valueOf((String)result.type)));
            }
        }
        return breadcrumb;
    }

    private FlowNodeType getFirstBucketFlowNodeType(Buckets<LongTermsBucket> buckets) {
        TopHitsAggregate topHits = ((Aggregate)((LongTermsBucket)buckets.array().get(0)).aggregations().get("levelsTopHitsAgg")).topHits();
        if (topHits != null && topHits.hits().total().value() > 0L) {
            Result result = (Result)((JsonData)((Hit)topHits.hits().hits().get(0)).source()).to(Result.class);
            if (result.type != null) {
                return FlowNodeType.valueOf((String)result.type);
            }
        }
        return null;
    }

    private FlowNodeInstanceMetadata buildInstanceMetadata(FlowNodeInstanceEntity flowNodeInstance) {
        return this.flowNodeInstanceMetadataBuilder.buildFrom(flowNodeInstance);
    }

    private Aggregation getLevelsAggs() {
        return AggregationDSL.withSubaggregations((TermsAggregation)AggregationDSL.termAggregation((String)"level", (int)10000, Map.of("_key", SortOrder.Asc)), Map.of("levelsTopHitsAgg", AggregationDSL.topHitsAggregation((int)1, (SortOptions[])new SortOptions[0])._toAggregation()));
    }

    private Set<String> collectFinishedFlowNodes(FilterAggregate filterAggs) {
        Buckets buckets = ((Aggregate)filterAggs.aggregations().get("finishedFlowNodesBuckets")).sterms().buckets();
        if (buckets != null) {
            return buckets.array().stream().map(b -> b.key()).collect(Collectors.toSet());
        }
        return new HashSet<String>();
    }

    private Set<String> getIncidentPaths(FilterAggregate filterAggs) {
        StringTermsAggregate termsAggs;
        if (filterAggs != null && (termsAggs = ((Aggregate)filterAggs.aggregations().get("aggIncidentPaths")).sterms()) != null) {
            return termsAggs.buckets().array().stream().map(b -> b.key()).collect(Collectors.toSet());
        }
        return new HashSet<String>();
    }
}

