/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.opensearch.backup;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import io.camunda.operate.store.opensearch.response.OpenSearchGetSnapshotResponse;
import io.camunda.operate.store.opensearch.response.OpenSearchSnapshotInfo;
import io.camunda.operate.store.opensearch.response.SnapshotState;
import io.camunda.operate.util.ThreadUtil;
import io.camunda.operate.webapp.api.v1.exceptions.ResourceNotFoundException;
import io.camunda.operate.webapp.backup.BackupRepository;
import io.camunda.operate.webapp.backup.BackupService;
import io.camunda.operate.webapp.backup.Metadata;
import io.camunda.operate.webapp.management.dto.BackupStateDto;
import io.camunda.operate.webapp.management.dto.GetBackupStateResponseDetailDto;
import io.camunda.operate.webapp.management.dto.GetBackupStateResponseDto;
import io.camunda.operate.webapp.rest.exception.InvalidRequestException;
import java.net.SocketTimeoutException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch.snapshot.CreateSnapshotRequest;
import org.opensearch.client.opensearch.snapshot.DeleteSnapshotRequest;
import org.opensearch.client.opensearch.snapshot.GetSnapshotRequest;
import org.opensearch.client.opensearch.snapshot.SnapshotInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchBackupRepository
implements BackupRepository {
    public static final String SNAPSHOT_MISSING_EXCEPTION_TYPE = "snapshot_missing_exception";
    public static final String REPOSITORY_MISSING_EXCEPTION_TYPE = "repository_missing_exception";
    private static final Logger LOGGER = LoggerFactory.getLogger(OpensearchBackupRepository.class);
    private final RichOpenSearchClient richOpenSearchClient;
    private final ObjectMapper objectMapper;

    public OpensearchBackupRepository(RichOpenSearchClient richOpenSearchClient, ObjectMapper objectMapper) {
        this.richOpenSearchClient = richOpenSearchClient;
        this.objectMapper = objectMapper;
    }

    public void deleteSnapshot(String repositoryName, String snapshotName) {
        DeleteSnapshotRequest.Builder requestBuilder = RequestDSL.deleteSnapshotRequestBuilder((String)repositoryName, (String)snapshotName);
        ((CompletableFuture)this.richOpenSearchClient.async().snapshot().delete(requestBuilder).thenAccept(response -> LOGGER.debug("Delete snapshot was acknowledged by Opensearch node: {}", (Object)response.acknowledged()))).exceptionally(t -> {
            if (this.isSnapshotMissingException(t)) {
                LOGGER.warn("No snapshot found for snapshot deletion: {} ", (Object)t.getMessage());
            } else {
                LOGGER.error("Exception occurred while deleting the snapshot: {} ", (Object)t.getMessage(), t);
            }
            return null;
        });
    }

    public void validateRepositoryExists(String repositoryName) {
        try {
            Map repositoryResponse = this.richOpenSearchClient.snapshot().getRepository(RequestDSL.repositoryRequestBuilder((String)repositoryName));
            LOGGER.debug("Repository {} exists", (Object)repositoryResponse);
        }
        catch (Exception e) {
            if (this.isRepositoryMissingException(e)) {
                String reason = OpensearchBackupRepository.noRepositoryErrorMessage((String)repositoryName);
                throw new OperateRuntimeException(reason);
            }
            String reason = String.format("Exception occurred when validating existence of repository with name [%s].", repositoryName);
            throw new OperateRuntimeException(reason, (Throwable)e);
        }
    }

    public void validateNoDuplicateBackupId(String repositoryName, Long backupId) {
        OpenSearchGetSnapshotResponse response;
        String snapshot = Metadata.buildSnapshotNamePrefix((Long)backupId) + "*";
        try {
            response = this.richOpenSearchClient.snapshot().get(RequestDSL.getSnapshotRequestBuilder((String)repositoryName, (String)snapshot));
        }
        catch (Exception e) {
            if (this.isSnapshotMissingException((Throwable)e)) {
                return;
            }
            String reason = String.format("Exception occurred when validating whether backup with ID [%s] already exists.", backupId);
            throw new OperateRuntimeException(reason, (Throwable)e);
        }
        if (!response.snapshots().isEmpty()) {
            String reason = String.format("A backup with ID [%s] already exists. Found snapshots: [%s]", backupId, response.snapshots().stream().map(OpenSearchSnapshotInfo::getUuid).collect(Collectors.joining(", ")));
            throw new InvalidRequestException(reason);
        }
    }

    public GetBackupStateResponseDto getBackupState(String repositoryName, Long backupId) {
        List snapshots = this.findSnapshots(repositoryName, backupId);
        return this.toGetBackupStateResponseDto(backupId, snapshots);
    }

    public List<GetBackupStateResponseDto> getBackups(String repositoryName) {
        GetSnapshotRequest.Builder requestBuilder = RequestDSL.getSnapshotRequestBuilder((String)repositoryName, (String)"camunda_operate_*");
        try {
            OpenSearchGetSnapshotResponse response = this.richOpenSearchClient.snapshot().get(requestBuilder);
            List<OpenSearchSnapshotInfo> snapshots = response.snapshots().stream().sorted(Comparator.comparing(OpenSearchSnapshotInfo::getStartTimeInMillis).reversed()).toList();
            LinkedHashMap groupedSnapshotInfos = snapshots.stream().collect(Collectors.groupingBy(si -> {
                Metadata metadata = (Metadata)this.objectMapper.convertValue((Object)si.getMetadata(), Metadata.class);
                Long backupId = metadata.getBackupId();
                if (backupId == null) {
                    backupId = Metadata.extractBackupIdFromSnapshotName((String)si.getSnapshot());
                }
                return backupId;
            }, LinkedHashMap::new, Collectors.toList()));
            return groupedSnapshotInfos.entrySet().stream().map(entry -> this.toGetBackupStateResponseDto((Long)entry.getKey(), (List)entry.getValue())).toList();
        }
        catch (Exception e) {
            if (this.isRepositoryMissingException(e)) {
                String reason = OpensearchBackupRepository.noRepositoryErrorMessage((String)repositoryName);
                throw new OperateRuntimeException(reason);
            }
            if (this.isSnapshotMissingException((Throwable)e)) {
                return new ArrayList<GetBackupStateResponseDto>();
            }
            String reason = String.format("Exception occurred when searching for backups: %s", e.getMessage());
            throw new OperateRuntimeException(reason, (Throwable)e);
        }
    }

    public void executeSnapshotting(BackupService.SnapshotRequest snapshotRequest, Runnable onSuccess, Runnable onFailure) {
        Long backupId = this.backupId(snapshotRequest);
        Metadata metadata = snapshotRequest.metadata();
        Map<String, JsonData> metadataJson = Map.of("backupId", JsonData.of((Object)metadata.getBackupId()), "version", JsonData.of((Object)metadata.getVersion()), "partNo", JsonData.of((Object)metadata.getPartNo()), "partCount", JsonData.of((Object)metadata.getPartCount()));
        CreateSnapshotRequest.Builder requestBuilder = RequestDSL.createSnapshotRequestBuilder((String)snapshotRequest.repositoryName(), (String)snapshotRequest.snapshotName(), (List)snapshotRequest.indices()).ignoreUnavailable(Boolean.valueOf(false)).metadata(metadataJson).featureStates("none", new String[0]).waitForCompletion(Boolean.valueOf(true));
        ((CompletableFuture)this.richOpenSearchClient.async().snapshot().create(requestBuilder).thenAccept(response -> this.handleSnapshotReceived(response.snapshot(), onSuccess, onFailure))).exceptionally(e -> {
            block4: {
                if (e instanceof SocketTimeoutException) {
                    Optional<OpenSearchSnapshotInfo> maybeCurrentSnapshot;
                    LOGGER.warn(String.format("Timeout while creating snapshot [%s] for backup id [%d]. Need to keep waiting with polling...", snapshotRequest.snapshotName(), backupId));
                    while (true) {
                        List snapshotInfos;
                        if ((maybeCurrentSnapshot = (snapshotInfos = this.findSnapshots(snapshotRequest.repositoryName(), backupId)).stream().filter(x -> Objects.equals(x.getSnapshot(), snapshotRequest.snapshotName())).findFirst()).isEmpty()) {
                            LOGGER.error(String.format("Expected (but not found) snapshot [%s] for backupId [%d].", snapshotRequest.snapshotName(), backupId));
                            onFailure.run();
                            break block4;
                        }
                        if (!SnapshotState.STARTED.equals((Object)maybeCurrentSnapshot.get().getState())) break;
                        ThreadUtil.sleepFor((long)100L);
                    }
                    this.handleSnapshotReceived(maybeCurrentSnapshot.get(), onSuccess, onFailure);
                } else {
                    LOGGER.error(String.format("Exception while creating snapshot [%s] for backup id [%d].", snapshotRequest.snapshotName(), backupId), e);
                    onFailure.run();
                }
            }
            return null;
        });
    }

    private boolean isSnapshotMissingException(Throwable t) {
        return t instanceof OpenSearchException && t.getMessage().contains("snapshot_missing_exception");
    }

    private boolean isRepositoryMissingException(Exception e) {
        return e instanceof OpenSearchException && e.getMessage().contains("repository_missing_exception");
    }

    private static String noRepositoryErrorMessage(String repositoryName) {
        return String.format("No repository with name [%s] could be found.", repositoryName);
    }

    private Long backupId(BackupService.SnapshotRequest snapshotRequest) {
        return Metadata.extractBackupIdFromSnapshotName((String)snapshotRequest.snapshotName());
    }

    private void handleSnapshotReceived(OpenSearchSnapshotInfo snapshotInfo, Runnable onSuccess, Runnable onFailure) {
        if (SnapshotState.SUCCESS.equals((Object)snapshotInfo.getState())) {
            LOGGER.info("Snapshot done: {}", (Object)snapshotInfo.getUuid());
            onSuccess.run();
        } else if (SnapshotState.FAILED.equals((Object)snapshotInfo.getState())) {
            LOGGER.error("Snapshot taking failed for {}", (Object)snapshotInfo.getUuid());
            onFailure.run();
        } else {
            LOGGER.warn("Snapshot state is {} for snapshot {}", (Object)snapshotInfo.getState(), (Object)snapshotInfo.getUuid());
            onSuccess.run();
        }
    }

    private void handleSnapshotReceived(SnapshotInfo snapshotInfo, Runnable onSuccess, Runnable onFailure) {
        if (SnapshotState.SUCCESS.equals((Object)SnapshotState.valueOf((String)snapshotInfo.state()))) {
            LOGGER.info("Snapshot done: {}", (Object)snapshotInfo.uuid());
            onSuccess.run();
        } else if (SnapshotState.FAILED.equals((Object)SnapshotState.valueOf((String)snapshotInfo.state()))) {
            LOGGER.error("Snapshot taking failed for {}, reason {}", (Object)snapshotInfo.uuid(), (Object)snapshotInfo.reason());
            onFailure.run();
        } else {
            LOGGER.warn("Snapshot state is {} for snapshot {}", (Object)snapshotInfo.state(), (Object)snapshotInfo.uuid());
            onSuccess.run();
        }
    }

    private List<OpenSearchSnapshotInfo> findSnapshots(String repositoryName, Long backupId) {
        GetSnapshotRequest.Builder requestBuilder = RequestDSL.getSnapshotRequestBuilder((String)repositoryName, (String)(Metadata.buildSnapshotNamePrefix((Long)backupId) + "*"));
        try {
            OpenSearchGetSnapshotResponse response = this.richOpenSearchClient.snapshot().get(requestBuilder);
            return response.snapshots();
        }
        catch (Exception e) {
            if (this.isSnapshotMissingException((Throwable)e)) {
                throw new ResourceNotFoundException(String.format("No backup with id [%s] found.", backupId));
            }
            if (this.isRepositoryMissingException(e)) {
                String reason = OpensearchBackupRepository.noRepositoryErrorMessage((String)repositoryName);
                throw new OperateRuntimeException(reason);
            }
            String reason = String.format("Exception occurred when searching for backup with ID [%s].", backupId);
            throw new OperateRuntimeException(reason, (Throwable)e);
        }
    }

    private BackupStateDto getState(List<OpenSearchSnapshotInfo> snapshots, Integer expectedSnapshotsCount) {
        if (snapshots.size() == expectedSnapshotsCount.intValue()) {
            if (snapshots.stream().map(OpenSearchSnapshotInfo::getState).allMatch(arg_0 -> SnapshotState.SUCCESS.equals(arg_0))) {
                return BackupStateDto.COMPLETED;
            }
        }
        if (snapshots.stream().map(OpenSearchSnapshotInfo::getState).anyMatch(s -> SnapshotState.FAILED.equals(s) || SnapshotState.PARTIAL.equals(s))) {
            return BackupStateDto.FAILED;
        }
        if (snapshots.stream().map(OpenSearchSnapshotInfo::getState).anyMatch(arg_0 -> SnapshotState.STARTED.equals(arg_0))) {
            return BackupStateDto.IN_PROGRESS;
        }
        if (snapshots.size() < expectedSnapshotsCount) {
            return BackupStateDto.INCOMPLETE;
        }
        return BackupStateDto.FAILED;
    }

    private GetBackupStateResponseDto toGetBackupStateResponseDto(Long backupId, List<OpenSearchSnapshotInfo> snapshots) {
        GetBackupStateResponseDto response = new GetBackupStateResponseDto(backupId);
        Metadata metadata = (Metadata)this.objectMapper.convertValue((Object)snapshots.get(0).getMetadata(), Metadata.class);
        Integer expectedSnapshotsCount = metadata.getPartCount();
        response.setState(this.getState(snapshots, expectedSnapshotsCount));
        response.setDetails(this.getBackupStateDetails(snapshots));
        String failureReason = this.getFailureReason(snapshots, response.getState(), expectedSnapshotsCount);
        if (failureReason != null) {
            response.setFailureReason(failureReason);
        }
        return response;
    }

    private List<GetBackupStateResponseDetailDto> getBackupStateDetails(List<OpenSearchSnapshotInfo> snapshots) {
        ArrayList<GetBackupStateResponseDetailDto> details = new ArrayList<GetBackupStateResponseDetailDto>();
        for (OpenSearchSnapshotInfo snapshot : snapshots) {
            GetBackupStateResponseDetailDto detail = new GetBackupStateResponseDetailDto();
            detail.setSnapshotName(snapshot.getSnapshot());
            detail.setStartTime(OffsetDateTime.ofInstant(Instant.ofEpochMilli(snapshot.getStartTimeInMillis()), ZoneId.systemDefault()));
            if (!snapshot.getFailures().isEmpty()) {
                detail.setFailures((String[])snapshot.getFailures().stream().map(Object::toString).toArray(String[]::new));
            }
            detail.setState(snapshot.getState().toString());
            details.add(detail);
        }
        return details;
    }

    private String getFailureReason(List<OpenSearchSnapshotInfo> snapshots, BackupStateDto state, Integer expectedSnapshotsCount) {
        if (state == BackupStateDto.FAILED) {
            String failedSnapshots = snapshots.stream().filter(s -> SnapshotState.FAILED.equals((Object)s.getState())).map(OpenSearchSnapshotInfo::getSnapshot).collect(Collectors.joining(", "));
            if (!failedSnapshots.isEmpty()) {
                return String.format("There were failures with the following snapshots: %s", failedSnapshots);
            }
            String partialSnapshot = snapshots.stream().filter(s -> SnapshotState.PARTIAL.equals((Object)s.getState())).map(OpenSearchSnapshotInfo::getSnapshot).collect(Collectors.joining(", "));
            if (!partialSnapshot.isEmpty()) {
                return String.format("Some of the snapshots are partial: %s", partialSnapshot);
            }
            if (snapshots.size() > expectedSnapshotsCount) {
                return "More snapshots found than expected.";
            }
        }
        return null;
    }
}

