/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.opensearch;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.schema.indices.OperateWebSessionIndex;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import io.camunda.operate.webapp.opensearch.OpensearchSessionRepository;
import io.camunda.operate.webapp.security.OperateSession;
import io.camunda.operate.webapp.security.SessionRepository;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.opensearch.client.opensearch.core.IndexRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchSessionRepository
implements SessionRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpensearchSessionRepository.class);
    private final RichOpenSearchClient richOpenSearchClient;
    private final GenericConversionService conversionService;
    private final OperateWebSessionIndex operateWebSessionIndex;
    private final HttpServletRequest request;

    public OpensearchSessionRepository(RichOpenSearchClient richOpenSearchClient, GenericConversionService conversionService, OperateWebSessionIndex operateWebSessionIndex, HttpServletRequest request) {
        this.richOpenSearchClient = richOpenSearchClient;
        this.conversionService = conversionService;
        this.operateWebSessionIndex = operateWebSessionIndex;
        this.request = request;
    }

    @PostConstruct
    private void setUp() {
        this.setupConverter();
    }

    private void setupConverter() {
        this.conversionService.addConverter(Object.class, byte[].class, (Converter)new SerializingConverter());
        this.conversionService.addConverter(byte[].class, Object.class, (Converter)new DeserializingConverter());
    }

    private SessionEntity toSessionEntity(OperateSession session) {
        Map attributes = session.getAttributeNames().stream().collect(Collectors.toMap(UnaryOperator.identity(), name -> this.serialize(session.getAttribute(name))));
        return new SessionEntity(session.getId(), Long.valueOf(session.getCreationTime().toEpochMilli()), Long.valueOf(session.getLastAccessedTime().toEpochMilli()), Long.valueOf(session.getMaxInactiveInterval().getSeconds()), attributes, Boolean.valueOf(session.isPolling()));
    }

    private String serialize(Object object) {
        return new String(Base64.getEncoder().encode((byte[])this.conversionService.convert(object, TypeDescriptor.valueOf(Object.class), TypeDescriptor.valueOf(byte[].class))));
    }

    private OperateSession toOperateSession(SessionEntity sessionEntity) {
        OperateSession session = new OperateSession(sessionEntity.id());
        session.setCreationTime((Instant)this.nullable((Object)sessionEntity.creationTime, Instant::ofEpochMilli));
        session.setLastAccessedTime((Instant)this.nullable((Object)sessionEntity.lastAccessedTime, Instant::ofEpochMilli));
        session.setMaxInactiveInterval((Duration)this.nullable((Object)sessionEntity.maxInactiveIntervalInSeconds, Duration::ofSeconds));
        if (sessionEntity.attributes() != null) {
            sessionEntity.attributes().forEach((key, value) -> session.setAttribute(key, this.deserialize(value)));
        }
        try {
            if (this.request != null && this.request.getHeader("x-is-polling") != null) {
                session.setPolling(true);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Expected Exception: is not possible to access request as currently this is not on a request context");
        }
        return session;
    }

    private Object deserialize(String s) {
        byte[] bytes = Base64.getDecoder().decode(s.getBytes());
        return this.conversionService.convert((Object)bytes, TypeDescriptor.valueOf(byte[].class), TypeDescriptor.valueOf(Object.class));
    }

    private <A, R> R nullable(A a, Function<A, R> f) {
        return a == null ? null : (R)f.apply(a);
    }

    public List<String> getExpiredSessionIds() {
        return this.richOpenSearchClient.doc().scrollValues(RequestDSL.searchRequestBuilder((String)this.operateWebSessionIndex.getFullQualifiedName()), SessionEntity.class).stream().map(arg_0 -> this.toOperateSession(arg_0)).filter(OperateSession::isExpired).map(OperateSession::getId).toList();
    }

    public void save(OperateSession session) {
        IndexRequest.Builder requestBuilder = RequestDSL.indexRequestBuilder((String)this.operateWebSessionIndex.getFullQualifiedName()).id(session.getId()).document((Object)this.toSessionEntity(session));
        this.richOpenSearchClient.doc().indexWithRetries(requestBuilder);
    }

    public Optional<OperateSession> findById(String id) {
        try {
            return this.richOpenSearchClient.doc().getWithRetries(this.operateWebSessionIndex.getFullQualifiedName(), id, SessionEntity.class).map(arg_0 -> this.toOperateSession(arg_0));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public void deleteById(String id) {
        this.richOpenSearchClient.doc().deleteWithRetries(this.operateWebSessionIndex.getFullQualifiedName(), id);
    }
}

