/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.opensearch;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.entities.FlowNodeState;
import io.camunda.operate.entities.FlowNodeType;
import io.camunda.operate.entities.listview.ProcessInstanceState;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import io.camunda.operate.util.CollectionUtil;
import io.camunda.operate.webapp.rest.dto.listview.ListViewQueryDto;
import io.camunda.operate.webapp.rest.dto.listview.VariablesQueryDto;
import io.camunda.operate.webapp.rest.exception.InvalidRequestException;
import io.camunda.operate.webapp.security.identity.IdentityPermission;
import io.camunda.operate.webapp.security.identity.PermissionsService;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.ArrayUtils;
import org.opensearch.client.opensearch._types.query_dsl.Operator;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.RangeQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpenSearchQueryHelper {
    private static final String WILD_CARD = "*";
    @Autowired
    private OperateProperties operateProperties;
    @Autowired
    private DateTimeFormatter dateTimeFormatter;
    @Autowired(required=false)
    private PermissionsService permissionsService;

    public Query createProcessInstancesQuery(ListViewQueryDto query) {
        return QueryDSL.constantScore((Query)QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)"joinRelation", (String)"processInstance"), this.createQueryFragment(query)}));
    }

    public Query createQueryFragment(ListViewQueryDto query) {
        return this.createQueryFragment(query, RequestDSL.QueryType.ALL);
    }

    public Query createQueryFragment(ListViewQueryDto query, RequestDSL.QueryType queryType) {
        return QueryDSL.and((Query[])new Query[]{this.runningFinishedQuery(query, queryType), this.createRetriesLeftQuery(query), this.activityIdQuery(query, queryType), this.idsQuery(query), this.errorMessageQuery(query), this.dateRangeQuery("startDate", query.getStartDateAfter(), query.getStartDateBefore()), this.dateRangeQuery("endDate", query.getEndDateAfter(), query.getEndDateBefore()), this.processDefinitionKeysQuery(query), this.bpmnProcessIdQuery(query), this.excludeIdsQuery(query), this.variablesQuery(query), this.batchOperationIdQuery(query), this.parentInstanceIdQuery(query), this.tenantIdQuery(query), this.readPermissionQuery()});
    }

    private Query runningFinishedQuery(ListViewQueryDto query, RequestDSL.QueryType queryType) {
        Query processInstanceQuery;
        boolean active = query.isActive();
        boolean incidents = query.isIncidents();
        boolean running = query.isRunning();
        boolean completed = query.isCompleted();
        boolean canceled = query.isCanceled();
        boolean finished = query.isFinished();
        if (!running && !finished) {
            return QueryDSL.matchNone();
        }
        if (running && finished && active && incidents && completed && canceled) {
            return null;
        }
        Query runningQuery = null;
        if (running && (active || incidents)) {
            Query incidentsQuery;
            runningQuery = QueryDSL.not((Query[])new Query[]{QueryDSL.exists((String)"endDate")});
            Query activeQuery = query.isActive() ? QueryDSL.term((String)"incident", (boolean)false) : null;
            Query query2 = incidentsQuery = query.isIncidents() ? QueryDSL.term((String)"incident", (boolean)true) : null;
            if (query.getActivityId() != null || !query.isActive() || !query.isIncidents()) {
                runningQuery = QueryDSL.and((Query[])new Query[]{runningQuery, QueryDSL.or((Query[])new Query[]{activeQuery, incidentsQuery})});
            }
        }
        Query finishedQuery = null;
        if (finished && (completed || canceled)) {
            Query canceledQuery;
            finishedQuery = QueryDSL.exists((String)"endDate");
            Query completedQuery = query.isCompleted() ? QueryDSL.term((String)"state", (String)ProcessInstanceState.COMPLETED.toString()) : null;
            Query query3 = canceledQuery = query.isCanceled() ? QueryDSL.term((String)"state", (String)ProcessInstanceState.CANCELED.toString()) : null;
            if (query.getActivityId() != null || !query.isCompleted() || !query.isCanceled()) {
                finishedQuery = QueryDSL.and((Query[])new Query[]{finishedQuery, QueryDSL.or((Query[])new Query[]{completedQuery, canceledQuery})});
            }
        }
        if ((processInstanceQuery = QueryDSL.or((Query[])new Query[]{runningQuery, finishedQuery})) == null) {
            return QueryDSL.matchNone();
        }
        return processInstanceQuery;
    }

    private Query createRetriesLeftQuery(ListViewQueryDto query) {
        if (query.isRetriesLeft()) {
            Query retriesLeftQuery = QueryDSL.term((String)"jobFailedWithRetriesLeft", (boolean)true);
            return QueryDSL.hasChildQuery((String)"activity", (Query)retriesLeftQuery);
        }
        return null;
    }

    private Query activityIdQuery(String activityId, FlowNodeState state) {
        Query query = QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)"activityState", (String)state.name()), QueryDSL.term((String)"activityId", (String)activityId), state == FlowNodeState.COMPLETED ? QueryDSL.term((String)"activityType", (String)FlowNodeType.END_EVENT.name()) : null});
        return QueryDSL.hasChildQuery((String)"activity", (Query)query);
    }

    private Query activityIdIncidentQuery(String activityId) {
        Query query = QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)"activityState", (String)FlowNodeState.ACTIVE.name()), QueryDSL.term((String)"activityId", (String)activityId), QueryDSL.exists((String)"errorMessage")});
        return QueryDSL.hasChildQuery((String)"activity", (Query)query);
    }

    private Query activityIdQuery(ListViewQueryDto query, RequestDSL.QueryType queryType) {
        if (!StringUtils.hasLength((String)query.getActivityId())) {
            return null;
        }
        return QueryDSL.or((Query[])new Query[]{query.isActive() ? this.activityIdQuery(query.getActivityId(), FlowNodeState.ACTIVE) : null, query.isIncidents() ? this.activityIdIncidentQuery(query.getActivityId()) : null, query.isCompleted() ? this.activityIdQuery(query.getActivityId(), FlowNodeState.COMPLETED) : null, query.isCanceled() ? this.activityIdQuery(query.getActivityId(), FlowNodeState.TERMINATED) : null});
    }

    private Query idsQuery(ListViewQueryDto query) {
        if (CollectionUtil.isNotEmpty((Collection)query.getIds())) {
            return QueryDSL.stringTerms((String)"id", (Collection)query.getIds());
        }
        return null;
    }

    private Query errorMessageQuery(ListViewQueryDto query) {
        String errorMessage = query.getErrorMessage();
        if (StringUtils.hasLength((String)errorMessage)) {
            if (errorMessage.contains(WILD_CARD)) {
                return QueryDSL.hasChildQuery((String)"activity", (Query)QueryDSL.wildcardQuery((String)"errorMessage", (String)errorMessage.toLowerCase()));
            }
            return QueryDSL.hasChildQuery((String)"activity", (Query)QueryDSL.match((String)"errorMessage", (String)errorMessage, (Operator)Operator.And));
        }
        return null;
    }

    private Query dateRangeQuery(String field, OffsetDateTime dateAfter, OffsetDateTime dateBefore) {
        if (dateAfter != null || dateBefore != null) {
            RangeQuery.Builder rangeQueryBuilder = new RangeQuery.Builder().field(field);
            if (dateAfter != null) {
                rangeQueryBuilder.gte(QueryDSL.json((Object)this.dateTimeFormatter.format(dateAfter)));
            }
            if (dateBefore != null) {
                rangeQueryBuilder.lt(QueryDSL.json((Object)this.dateTimeFormatter.format(dateBefore)));
            }
            rangeQueryBuilder.format(this.operateProperties.getOpensearch().getOsDateFormat());
            return rangeQueryBuilder.build()._toQuery();
        }
        return null;
    }

    private Query processDefinitionKeysQuery(ListViewQueryDto query) {
        return CollectionUtil.isNotEmpty((Collection)query.getProcessIds()) ? QueryDSL.stringTerms((String)"processDefinitionKey", (Collection)query.getProcessIds()) : null;
    }

    private Query bpmnProcessIdQuery(ListViewQueryDto query) {
        if (!StringUtils.isEmpty((Object)query.getBpmnProcessId())) {
            return QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)"bpmnProcessId", (String)query.getBpmnProcessId()), query.getProcessVersion() != null ? QueryDSL.term((String)"processVersion", (Integer)query.getProcessVersion()) : null});
        }
        return null;
    }

    private Query excludeIdsQuery(ListViewQueryDto query) {
        return CollectionUtil.isNotEmpty((Collection)query.getExcludeIds()) ? QueryDSL.not((Query[])new Query[]{QueryDSL.stringTerms((String)"id", (Collection)query.getExcludeIds())}) : null;
    }

    private Query variablesQuery(ListViewQueryDto query) {
        boolean nonEmptyQuery;
        VariablesQueryDto variablesQuery = query.getVariable();
        boolean bl = nonEmptyQuery = variablesQuery != null && (StringUtils.hasLength((String)variablesQuery.getValue()) || !ArrayUtils.isEmpty((Object[])variablesQuery.getValues()));
        if (nonEmptyQuery) {
            if (!StringUtils.hasLength((String)variablesQuery.getName())) {
                throw new InvalidRequestException("Variables query must provide not-null variable name.");
            }
            Query valueQuery = variablesQuery.getValue() != null ? QueryDSL.term((String)"varValue", (String)variablesQuery.getValue()) : QueryDSL.stringTerms((String)"varValue", Arrays.asList(variablesQuery.getValues()));
            return QueryDSL.hasChildQuery((String)"variable", (Query)QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)"varName", (String)variablesQuery.getName()), valueQuery}));
        }
        return null;
    }

    private Query batchOperationIdQuery(ListViewQueryDto query) {
        return query.getBatchOperationId() != null ? QueryDSL.term((String)"batchOperationIds", (String)query.getBatchOperationId()) : null;
    }

    private Query parentInstanceIdQuery(ListViewQueryDto query) {
        return query.getParentInstanceId() != null ? QueryDSL.term((String)"parentProcessInstanceKey", (Long)query.getParentInstanceId()) : null;
    }

    private Query tenantIdQuery(ListViewQueryDto query) {
        return query.getTenantId() != null ? QueryDSL.term((String)"tenantId", (String)query.getTenantId()) : null;
    }

    private Query readPermissionQuery() {
        if (this.permissionsService == null) {
            return null;
        }
        PermissionsService.ResourcesAllowed allowed = this.permissionsService.getProcessesWithPermission(IdentityPermission.READ);
        if (allowed == null) {
            return null;
        }
        return allowed.isAll() ? QueryDSL.matchAll() : QueryDSL.stringTerms((String)"bpmnProcessId", (Collection)allowed.getIds());
    }
}

