/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.management;

import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.webapp.api.v1.rest.ErrorController;
import io.camunda.operate.webapp.backup.BackupService;
import io.camunda.operate.webapp.management.dto.GetBackupStateResponseDto;
import io.camunda.operate.webapp.management.dto.TakeBackupRequestDto;
import io.camunda.operate.webapp.management.dto.TakeBackupResponseDto;
import io.camunda.operate.webapp.rest.exception.InvalidRequestException;
import io.camunda.operate.webapp.rest.exception.NotFoundException;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Component
@RestControllerEndpoint(id="backups")
public class BackupController
extends ErrorController {
    private final Pattern pattern = Pattern.compile("((?![A-Z \"*\\\\<|,>\\/?_]).){0,3996}$");
    @Autowired
    private BackupService backupService;
    @Autowired
    private OperateProperties operateProperties;

    @PostMapping(produces={"application/json"})
    public TakeBackupResponseDto takeBackup(@RequestBody TakeBackupRequestDto request) {
        this.validateRequest(request);
        this.validateRepositoryNameIsConfigured();
        return this.backupService.takeBackup(request);
    }

    private void validateRepositoryNameIsConfigured() {
        if (this.operateProperties.getBackup() == null || this.operateProperties.getBackup().getRepositoryName() == null || this.operateProperties.getBackup().getRepositoryName().isEmpty()) {
            throw new NotFoundException("No backup repository configured.");
        }
    }

    @GetMapping(value={"/{backupId}"})
    public GetBackupStateResponseDto getBackupState(@PathVariable Long backupId) {
        this.validateBackupId(backupId);
        this.validateRepositoryNameIsConfigured();
        return this.backupService.getBackupState(backupId);
    }

    @GetMapping
    public List<GetBackupStateResponseDto> getBackups() {
        this.validateRepositoryNameIsConfigured();
        return this.backupService.getBackups();
    }

    @DeleteMapping(value={"/{backupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteBackup(@PathVariable Long backupId) {
        this.validateBackupId(backupId);
        this.validateRepositoryNameIsConfigured();
        this.backupService.deleteBackup(backupId);
    }

    private void validateRequest(TakeBackupRequestDto request) {
        if (request.getBackupId() == null) {
            throw new InvalidRequestException("BackupId must be provided");
        }
        this.validateBackupId(request.getBackupId());
    }

    private void validateBackupId(Long backupId) {
        if (backupId < 0L) {
            throw new InvalidRequestException("BackupId must be a non-negative Integer. Received value: " + backupId);
        }
    }
}

